/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.CRIFImpl;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TransposeBinaryOpImage;
import com.sun.media.jai.opimage.TransposeOpImage;
import java.awt.RenderingHints;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.TileCache;

public class TransposeCRIF
extends CRIFImpl {
    public TransposeCRIF() {
        super("transpose");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        int n = parameterBlock.getIntParameter(0);
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3)) {
            return new TransposeBinaryOpImage(renderedImage, tileCache, imageLayout, n);
        }
        return new TransposeOpImage(renderedImage, tileCache, imageLayout, n);
    }
}

