/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.SunTileCache;
import com.sun.media.jai.util.SunTileScheduler;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.CollectionOp;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;

public final class JAI {
    private static final int HINT_IMAGE_LAYOUT = 101;
    private static final int HINT_INTERPOLATION = 102;
    private static final int HINT_OPERATION_REGISTRY = 103;
    private static final int HINT_OPERATION_BOUND = 104;
    private static final int HINT_BORDER_EXTENDER = 105;
    private static final int HINT_TILE_CACHE = 106;
    public static RenderingHints.Key KEY_IMAGE_LAYOUT = new RenderingKey(101, class$javax$media$jai$ImageLayout != null ? class$javax$media$jai$ImageLayout : (class$javax$media$jai$ImageLayout = JAI.class$("javax.media.jai.ImageLayout")));
    public static RenderingHints.Key KEY_INTERPOLATION = new RenderingKey(102, class$javax$media$jai$Interpolation != null ? class$javax$media$jai$Interpolation : (class$javax$media$jai$Interpolation = JAI.class$("javax.media.jai.Interpolation")));
    public static RenderingHints.Key KEY_OPERATION_REGISTRY = new RenderingKey(103, class$javax$media$jai$OperationRegistry != null ? class$javax$media$jai$OperationRegistry : (class$javax$media$jai$OperationRegistry = JAI.class$("javax.media.jai.OperationRegistry")));
    public static RenderingHints.Key KEY_OPERATION_BOUND = new RenderingKey(104, class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = JAI.class$("java.lang.Integer")));
    public static RenderingHints.Key KEY_BORDER_EXTENDER = new RenderingKey(105, class$javax$media$jai$BorderExtender != null ? class$javax$media$jai$BorderExtender : (class$javax$media$jai$BorderExtender = JAI.class$("javax.media.jai.BorderExtender")));
    public static RenderingHints.Key KEY_TILE_CACHE = new RenderingKey(106, class$javax$media$jai$TileCache != null ? class$javax$media$jai$TileCache : (class$javax$media$jai$TileCache = JAI.class$("javax.media.jai.TileCache")));
    private OperationRegistry operationRegistry;
    private TileScheduler tileScheduler;
    private TileCache tileCache;
    private RenderingHints renderingHints;
    private static JAI defaultInstance = new JAI(OperationRegistry.initializeRegistry(), new SunTileScheduler(), new SunTileCache(), new RenderingHints(null));
    static /* synthetic */ Class class$javax$media$jai$ImageLayout;
    static /* synthetic */ Class class$javax$media$jai$Interpolation;
    static /* synthetic */ Class class$javax$media$jai$OperationRegistry;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$media$jai$BorderExtender;
    static /* synthetic */ Class class$javax$media$jai$TileCache;
    static /* synthetic */ Class class$java$awt$image$RenderedImage;
    static /* synthetic */ Class class$javax$media$jai$CollectionImage;
    static /* synthetic */ Class class$java$awt$image$renderable$RenderableImage;

    public JAI() {
        this.operationRegistry = JAI.defaultInstance.operationRegistry;
        this.tileScheduler = JAI.defaultInstance.tileScheduler;
        this.tileCache = JAI.defaultInstance.tileCache;
        this.renderingHints = (RenderingHints)JAI.defaultInstance.renderingHints.clone();
    }

    private JAI(OperationRegistry operationRegistry, TileScheduler tileScheduler, TileCache tileCache, RenderingHints renderingHints) {
        this.operationRegistry = operationRegistry;
        this.tileScheduler = tileScheduler;
        this.tileCache = tileCache;
        this.renderingHints = renderingHints;
        this.renderingHints.put(KEY_OPERATION_REGISTRY, operationRegistry);
        this.renderingHints.put(KEY_TILE_CACHE, tileCache);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearRenderingHints() {
        this.renderingHints = new RenderingHints(null);
    }

    public static RenderedOp create(String string, int n, int n2, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, float f3, float f4, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(f4);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, float f3, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, int n, float f2, float f3, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(n);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n, int n2, int n3, int n4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(n3);
        parameterBlock.add(n4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(n3);
        parameterBlock.add(n4);
        parameterBlock.add(n5);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, RenderedImage renderedImage2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, RenderedImage renderedImage2, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, float f) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(f);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, int n, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, int n, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4, Object object5) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        parameterBlock.add(object5);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        parameterBlock.add(object5);
        parameterBlock.add(object6);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, ParameterBlock parameterBlock) {
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createNS(string, parameterBlock, renderingHints);
    }

    public static RenderedOp create(String string, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(n);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, int n, Object object2, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(n);
        parameterBlock.add(object2);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2, Object object3) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Collection collection) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(collection);
        return JAI.create(string, parameterBlock, null);
    }

    public static Collection createCollection(String string, ParameterBlock parameterBlock) {
        return JAI.createCollection(string, parameterBlock, null);
    }

    public static Collection createCollection(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createCollectionNS(string, parameterBlock, renderingHints);
    }

    public Collection createCollectionNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        Object object;
        Collection<Collection> collection;
        RenderingHints renderingHints2;
        OperationDescriptor operationDescriptor = this.operationRegistry.getOperationDescriptor(string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI0"));
        }
        if (!operationDescriptor.isRenderedSupported()) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI1"));
        }
        Class clazz = operationDescriptor.getDestClass();
        if (clazz != (class$java$awt$image$RenderedImage != null ? class$java$awt$image$RenderedImage : (class$java$awt$image$RenderedImage = JAI.class$("java.awt.image.RenderedImage"))) && clazz != (class$javax$media$jai$CollectionImage != null ? class$javax$media$jai$CollectionImage : (class$javax$media$jai$CollectionImage = JAI.class$("javax.media.jai.CollectionImage")))) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI5"));
        }
        if (renderingHints == null) {
            renderingHints2 = this.renderingHints;
        } else if (this.renderingHints.isEmpty()) {
            renderingHints2 = renderingHints;
        } else {
            renderingHints2 = new RenderingHints(this.renderingHints);
            renderingHints2.add(renderingHints);
        }
        StringBuffer stringBuffer = new StringBuffer();
        parameterBlock = (ParameterBlock)parameterBlock.clone();
        if (operationDescriptor.validateArguments(parameterBlock, stringBuffer)) {
            if (clazz == (class$java$awt$image$RenderedImage != null ? class$java$awt$image$RenderedImage : (class$java$awt$image$RenderedImage = JAI.class$("java.awt.image.RenderedImage")))) {
                Vector<RenderedOp> vector = new Vector<RenderedOp>(1);
                vector.add(new RenderedOp(this.operationRegistry, string, parameterBlock, renderingHints2));
                return vector;
            }
            return new CollectionOp(this.operationRegistry, string, parameterBlock, renderingHints2);
        }
        int n = operationDescriptor.getNumSources();
        Vector<Object> vector = parameterBlock.getSources();
        Iterator[] iteratorArray = new Iterator[n];
        Iterator iterator = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < n) {
            collection = vector.elementAt(n3);
            if (collection instanceof Collection) {
                iteratorArray[n3] = ((Collection)collection).iterator();
                if (iterator == null || ((Collection)collection).size() < n2) {
                    iterator = iteratorArray[n3];
                    n2 = ((Collection)collection).size();
                }
            }
            ++n3;
        }
        if (iterator == null) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        collection = null;
        int n4 = 0;
        while (n4 < n) {
            object = vector.elementAt(n4);
            if (object instanceof Collection) {
                try {
                    collection = (Collection)object.getClass().newInstance();
                    break;
                }
                catch (Exception exception) {}
            }
            ++n4;
        }
        if (collection == null) {
            collection = new Vector();
        }
        while (iterator.hasNext()) {
            object = new ParameterBlock();
            ((ParameterBlock)object).setParameters(parameterBlock.getParameters());
            int n5 = 0;
            while (n5 < n) {
                if (iteratorArray[n5] == null) {
                    ((ParameterBlock)object).addSource(vector.elementAt(n5));
                } else {
                    ((ParameterBlock)object).addSource(iteratorArray[n5].next());
                }
                ++n5;
            }
            Collection collection2 = JAI.createCollection(string, (ParameterBlock)object, renderingHints2);
            if (collection2 instanceof Vector && collection2.size() == 1 && ((Vector)collection2).elementAt(0) instanceof RenderedOp) {
                collection.add((Collection)((Vector)collection2).elementAt(0));
                continue;
            }
            collection.add(collection2);
        }
        return collection;
    }

    public RenderedOp createNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderingHints renderingHints2;
        OperationDescriptor operationDescriptor = this.operationRegistry.getOperationDescriptor(string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI0"));
        }
        if (!operationDescriptor.isRenderedSupported()) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI1"));
        }
        if (operationDescriptor.getDestClass() != (class$java$awt$image$RenderedImage != null ? class$java$awt$image$RenderedImage : (class$java$awt$image$RenderedImage = JAI.class$("java.awt.image.RenderedImage")))) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI2"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateArguments(parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        if (renderingHints == null) {
            renderingHints2 = this.renderingHints;
        } else if (this.renderingHints.isEmpty()) {
            renderingHints2 = renderingHints;
        } else {
            renderingHints2 = new RenderingHints(this.renderingHints);
            renderingHints2.add(renderingHints);
        }
        RenderedOp renderedOp = new RenderedOp(this.operationRegistry, string, parameterBlock, renderingHints2);
        if (operationDescriptor.isImmediate()) {
            PlanarImage planarImage = null;
            try {
                planarImage = renderedOp.getRendering();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (planarImage == null) {
                return null;
            }
        }
        return renderedOp;
    }

    public static RenderableOp createRenderable(String string, ParameterBlock parameterBlock) {
        return defaultInstance.createRenderableNS(string, parameterBlock);
    }

    public static Collection createRenderableCollection(String string, ParameterBlock parameterBlock) {
        return defaultInstance.createRenderableCollectionNS(string, parameterBlock);
    }

    public Collection createRenderableCollectionNS(String string, ParameterBlock parameterBlock) {
        Object object;
        Collection<Collection> collection;
        OperationDescriptor operationDescriptor = this.operationRegistry.getOperationDescriptor(string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI0"));
        }
        if (!operationDescriptor.isRenderableSupported()) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI3"));
        }
        Class clazz = operationDescriptor.getRenderableDestClass();
        if (clazz != (class$java$awt$image$renderable$RenderableImage != null ? class$java$awt$image$renderable$RenderableImage : (class$java$awt$image$renderable$RenderableImage = JAI.class$("java.awt.image.renderable.RenderableImage"))) && clazz != (class$javax$media$jai$CollectionImage != null ? class$javax$media$jai$CollectionImage : (class$javax$media$jai$CollectionImage = JAI.class$("javax.media.jai.CollectionImage")))) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI6"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (operationDescriptor.validateRenderableArguments(parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            if (clazz == (class$java$awt$image$renderable$RenderableImage != null ? class$java$awt$image$renderable$RenderableImage : (class$java$awt$image$renderable$RenderableImage = JAI.class$("java.awt.image.renderable.RenderableImage")))) {
                Vector<RenderableOp> vector = new Vector<RenderableOp>(1);
                vector.add(new RenderableOp(this.operationRegistry, string, parameterBlock));
                return vector;
            }
            return new CollectionOp(this.operationRegistry, string, parameterBlock);
        }
        int n = operationDescriptor.getNumSources();
        Vector<Object> vector = parameterBlock.getSources();
        Iterator[] iteratorArray = new Iterator[n];
        Iterator iterator = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < n) {
            collection = vector.elementAt(n3);
            if (collection instanceof Collection) {
                iteratorArray[n3] = ((Collection)collection).iterator();
                if (iterator == null || ((Collection)collection).size() < n2) {
                    iterator = iteratorArray[n3];
                    n2 = ((Collection)collection).size();
                }
            }
            ++n3;
        }
        if (iterator == null) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        collection = null;
        int n4 = 0;
        while (n4 < n) {
            object = vector.elementAt(n4);
            if (object instanceof Collection) {
                try {
                    collection = (Collection)object.getClass().newInstance();
                    break;
                }
                catch (Exception exception) {}
            }
            ++n4;
        }
        if (collection == null) {
            collection = new Vector();
        }
        while (iterator.hasNext()) {
            object = new ParameterBlock();
            ((ParameterBlock)object).setParameters(parameterBlock.getParameters());
            int n5 = 0;
            while (n5 < n) {
                if (iteratorArray[n5] == null) {
                    ((ParameterBlock)object).addSource(vector.elementAt(n5));
                } else {
                    ((ParameterBlock)object).addSource(iteratorArray[n5].next());
                }
                ++n5;
            }
            Collection collection2 = JAI.createRenderableCollection(string, (ParameterBlock)object);
            if (collection2 instanceof Vector && collection2.size() == 1 && ((Vector)collection2).elementAt(0) instanceof RenderableOp) {
                collection.add((Collection)((Vector)collection2).elementAt(0));
                continue;
            }
            collection.add(collection2);
        }
        return collection;
    }

    public RenderableOp createRenderableNS(String string, ParameterBlock parameterBlock) {
        OperationDescriptor operationDescriptor = this.operationRegistry.getOperationDescriptor(string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI0"));
        }
        if (!operationDescriptor.isRenderableSupported()) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI3"));
        }
        if (operationDescriptor.getRenderableDestClass() != (class$java$awt$image$renderable$RenderableImage != null ? class$java$awt$image$renderable$RenderableImage : (class$java$awt$image$renderable$RenderableImage = JAI.class$("java.awt.image.renderable.RenderableImage")))) {
            throw new IllegalArgumentException(String.valueOf(string) + ": " + JaiI18N.getString("JAI4"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateRenderableArguments(parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        return new RenderableOp(this.operationRegistry, string, parameterBlock);
    }

    public static TileCache createTileCache() {
        return new SunTileCache();
    }

    public static TileCache createTileCache(int n, long l) {
        if (n < 0 || l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI10"));
        }
        return new SunTileCache(l);
    }

    public static JAI getDefaultInstance() {
        return defaultInstance;
    }

    public OperationRegistry getOperationRegistry() {
        return this.operationRegistry;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI7"));
        }
        return this.renderingHints.get(key);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    public TileScheduler getTileScheduler() {
        return this.tileScheduler;
    }

    public void removeRenderingHint(RenderingHints.Key key) {
        this.renderingHints.remove(key);
    }

    public void setOperationRegistry(OperationRegistry operationRegistry) {
        if (operationRegistry == null) {
            throw new NullPointerException();
        }
        this.operationRegistry = operationRegistry;
        this.renderingHints.put(KEY_OPERATION_REGISTRY, operationRegistry);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI8"));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI9"));
        }
        try {
            this.renderingHints.put(key, object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            renderingHints.toString();
        }
        this.renderingHints = renderingHints;
    }

    public void setTileCache(TileCache tileCache) {
        if (tileCache == null) {
            throw new NullPointerException();
        }
        this.tileCache = tileCache;
        this.renderingHints.put(KEY_TILE_CACHE, tileCache);
    }

    public void setTileScheduler(TileScheduler tileScheduler) {
        if (tileScheduler == null) {
            throw new NullPointerException();
        }
        this.tileScheduler = tileScheduler;
    }

    static class RenderingKey
    extends RenderingHints.Key {
        private Class objectClass;

        RenderingKey(int n, Class clazz) {
            super(n);
            this.objectClass = clazz;
        }

        public boolean isCompatibleValue(Object object) {
            return this.objectClass.isInstance(object);
        }
    }
}

