/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;

public abstract class PointOpImage
extends OpImage {
    private boolean areFieldsInitialized = false;
    private boolean checkInPlaceOperation = false;
    private boolean isInPlaceEnabled = false;
    private WritableRenderedImage source0AsWritableRenderedImage;
    private OpImage source0AsOpImage;
    private boolean source0IsWritableRenderedImage;
    private boolean sameBounds;
    private boolean sameTileGrid;

    public PointOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, RenderedImage renderedImage3, TileCache tileCache, ImageLayout imageLayout, boolean bl) {
        this(OpImage.vectorize(renderedImage, renderedImage2, renderedImage3), tileCache, imageLayout, bl);
    }

    public PointOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, TileCache tileCache, ImageLayout imageLayout, boolean bl) {
        super(renderedImage, renderedImage2, null, null, tileCache, imageLayout, bl);
    }

    public PointOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, boolean bl) {
        super(renderedImage, null, tileCache, imageLayout, bl);
    }

    public PointOpImage(Vector vector, TileCache tileCache, ImageLayout imageLayout, boolean bl) {
        super(vector, null, tileCache, imageLayout, bl);
    }

    public Raster computeTile(int n, int n2) {
        int n3;
        int n4;
        boolean bl;
        if (!this.cobbleSources) {
            return super.computeTile(n, n2);
        }
        if (!this.areFieldsInitialized) {
            this.initializeFields();
            this.areFieldsInitialized = true;
        }
        Raster raster = null;
        if (this.isInPlaceEnabled) {
            if (this.source0IsWritableRenderedImage) {
                raster = this.source0AsWritableRenderedImage.getWritableTile(n, n2);
            } else {
                Raster raster2 = this.source0AsOpImage.getTileFromCache(n, n2);
                if (raster2 == null) {
                    try {
                        raster2 = this.source0AsOpImage.computeTile(n, n2);
                        if (raster2 instanceof WritableRaster) {
                            raster = (WritableRaster)raster2;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        boolean bl2 = bl = raster != null;
        if (!bl) {
            Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
            raster = RasterFactory.createWritableRaster(this.sampleModel, point);
        }
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = n5 + raster.getWidth();
        int n8 = n6 + raster.getHeight();
        Rectangle rectangle = this.getBounds();
        if (n5 < rectangle.x) {
            n5 = rectangle.x;
        }
        if (n7 > (n4 = rectangle.x + rectangle.width)) {
            n7 = n4;
        }
        if (n6 < rectangle.y) {
            n6 = rectangle.y;
        }
        if (n8 > (n3 = rectangle.y + rectangle.height)) {
            n8 = n3;
        }
        int n9 = this.getNumSources();
        if (bl && n9 == 1) {
            Raster[] rasterArray = new Raster[]{raster};
            Rectangle rectangle2 = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            this.computeRect(rasterArray, (WritableRaster)raster, rectangle2);
        } else if (bl && this.sameBounds && this.sameTileGrid) {
            Raster[] rasterArray = new Raster[n9];
            rasterArray[0] = raster;
            int n10 = 1;
            while (n10 < n9) {
                rasterArray[n10] = this.getSource(n10).getTile(n, n2);
                ++n10;
            }
            Rectangle rectangle3 = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            this.computeRect(rasterArray, (WritableRaster)raster, rectangle3);
        } else {
            if (!this.sameBounds) {
                int n11 = bl ? 1 : 0;
                while (n11 < n9) {
                    rectangle = this.getSource(n11).getBounds();
                    if (n5 < rectangle.x) {
                        n5 = rectangle.x;
                    }
                    if (n7 > (n4 = rectangle.x + rectangle.width)) {
                        n7 = n4;
                    }
                    if (n6 < rectangle.y) {
                        n6 = rectangle.y;
                    }
                    if (n8 > (n3 = rectangle.y + rectangle.height)) {
                        n8 = n3;
                    }
                    if (n5 >= n7 || n6 >= n8) {
                        return raster;
                    }
                    ++n11;
                }
            }
            Rectangle rectangle4 = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            Raster[] rasterArray = new Raster[n9];
            if (this.sameTileGrid) {
                if (bl) {
                    rasterArray[0] = raster;
                }
                int n12 = bl ? 1 : 0;
                while (n12 < n9) {
                    rasterArray[n12] = this.getSource(n12).getTile(n, n2);
                    ++n12;
                }
                this.computeRect(rasterArray, (WritableRaster)raster, rectangle4);
            } else {
                IntegerSequence integerSequence = new IntegerSequence(n5, n7);
                integerSequence.insert(n5);
                integerSequence.insert(n7);
                IntegerSequence integerSequence2 = new IntegerSequence(n6, n8);
                integerSequence2.insert(n6);
                integerSequence2.insert(n8);
                int n13 = bl ? 1 : 0;
                while (n13 < n9) {
                    PlanarImage planarImage = this.getSource(n13);
                    planarImage.getSplits(integerSequence, integerSequence2, rectangle4);
                    ++n13;
                }
                Rectangle rectangle5 = new Rectangle();
                integerSequence2.startEnumeration();
                int n14 = integerSequence2.nextElement();
                while (integerSequence2.hasMoreElements()) {
                    int n15 = integerSequence2.nextElement();
                    int n16 = n15 - n14;
                    integerSequence.startEnumeration();
                    int n17 = integerSequence.nextElement();
                    while (integerSequence.hasMoreElements()) {
                        int n18 = integerSequence.nextElement();
                        int n19 = n18 - n17;
                        if (bl) {
                            rasterArray[0] = raster;
                        }
                        int n20 = bl ? 1 : 0;
                        while (n20 < n9) {
                            PlanarImage planarImage = this.getSource(n20);
                            int n21 = planarImage.XToTileX(n17);
                            int n22 = planarImage.YToTileY(n14);
                            rasterArray[n20] = planarImage.getTile(n21, n22);
                            ++n20;
                        }
                        rectangle5.x = n17;
                        rectangle5.y = n14;
                        rectangle5.width = n19;
                        rectangle5.height = n16;
                        this.computeRect(rasterArray, (WritableRaster)raster, rectangle5);
                        n17 = n18;
                    }
                    n14 = n15;
                }
            }
        }
        if (bl && this.source0IsWritableRenderedImage) {
            this.source0AsWritableRenderedImage.releaseWritableTile(n, n2);
        }
        return raster;
    }

    private boolean hasCompatibleSampleModel(PlanarImage planarImage) {
        boolean bl;
        SampleModel sampleModel = planarImage.getSampleModel();
        int n = this.sampleModel.getNumBands();
        boolean bl2 = bl = sampleModel.getTransferType() == this.sampleModel.getTransferType() && sampleModel.getWidth() == this.sampleModel.getWidth() && sampleModel.getHeight() == this.sampleModel.getHeight() && sampleModel.getNumBands() == n && sampleModel.getClass().equals(this.sampleModel.getClass());
        if (bl) {
            if (this.sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)this.sampleModel;
                bl = bl && componentSampleModel.getPixelStride() == componentSampleModel2.getPixelStride() && componentSampleModel.getScanlineStride() == componentSampleModel2.getScanlineStride();
                int[] nArray = componentSampleModel.getBankIndices();
                int[] nArray2 = componentSampleModel2.getBankIndices();
                int[] nArray3 = componentSampleModel.getBandOffsets();
                int[] nArray4 = componentSampleModel2.getBandOffsets();
                int n2 = 0;
                while (n2 < n && bl) {
                    bl = bl && nArray[n2] == nArray2[n2] && nArray3[n2] == nArray4[n2];
                    ++n2;
                }
            } else if (this.sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)this.sampleModel;
                bl = bl && singlePixelPackedSampleModel.getScanlineStride() == singlePixelPackedSampleModel2.getScanlineStride();
                int[] nArray = singlePixelPackedSampleModel.getBitMasks();
                int[] nArray5 = singlePixelPackedSampleModel2.getBitMasks();
                int n3 = 0;
                while (n3 < n && bl) {
                    bl = bl && nArray[n3] == nArray5[n3];
                    ++n3;
                }
            } else if (this.sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)this.sampleModel;
                bl = bl && multiPixelPackedSampleModel.getPixelBitStride() == multiPixelPackedSampleModel2.getPixelBitStride() && multiPixelPackedSampleModel.getScanlineStride() == multiPixelPackedSampleModel2.getScanlineStride() && multiPixelPackedSampleModel.getDataBitOffset() == multiPixelPackedSampleModel2.getDataBitOffset();
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private void initializeFields() {
        if (this.checkInPlaceOperation) {
            boolean bl = this.isInPlaceEnabled = this.source0 != null && this.getTileGridXOffset() == this.source0.getTileGridXOffset() && this.getTileGridYOffset() == this.source0.getTileGridYOffset() && this.getBounds().equals(this.source0.getBounds()) && this.source0 instanceof OpImage && this.hasCompatibleSampleModel(this.source0);
            if (this.isInPlaceEnabled && !((OpImage)this.source0).computesUniqueTiles()) {
                this.isInPlaceEnabled = false;
            }
            if (this.isInPlaceEnabled) {
                this.source0IsWritableRenderedImage = this.source0 instanceof WritableRenderedImage;
                if (this.source0IsWritableRenderedImage) {
                    this.source0AsWritableRenderedImage = (WritableRenderedImage)((Object)this.source0);
                } else {
                    this.source0AsOpImage = (OpImage)this.source0;
                }
            }
            this.checkInPlaceOperation = false;
        }
        int n = this.getNumSources();
        this.sameBounds = true;
        this.sameTileGrid = true;
        int n2 = 0;
        while (n2 < n && (this.sameBounds || this.sameTileGrid)) {
            PlanarImage planarImage = this.getSource(n2);
            if (this.sameBounds) {
                boolean bl = this.sameBounds = this.sameBounds && this.minX == planarImage.minX && this.minY == planarImage.minY && this.width == planarImage.width && this.height == planarImage.height;
            }
            if (this.sameTileGrid) {
                this.sameTileGrid = this.sameTileGrid && this.tileGridXOffset == planarImage.tileGridXOffset && this.tileGridYOffset == planarImage.tileGridYOffset && this.tileWidth == planarImage.tileWidth && this.tileHeight == planarImage.tileHeight;
            }
            ++n2;
        }
        this.areFieldsInitialized = true;
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        return new Rectangle(rectangle);
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        return new Rectangle(rectangle);
    }

    protected void permitInPlaceOperation() {
        Object var1_1 = null;
        try {
            var1_1 = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = "javax.media.jai.PointOpImage.InPlace";
                    return System.getProperty(string);
                }
            });
        }
        catch (SecurityException securityException) {}
        this.checkInPlaceOperation = (var1_1 != null && var1_1 instanceof String && ((String)var1_1).equalsIgnoreCase("false")) ^ true;
    }
}

