/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.rmi.RasterProxy;
import com.sun.media.jai.rmi.RenderingHintsProxy;
import com.sun.media.jai.rmi.SerializableRenderedImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.media.jai.CollectionOp;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;

public class RenderedOp
extends PlanarImage
implements Serializable {
    protected transient PlanarImage theImage;
    private transient OperationRegistry theRegistry;
    private String operationName;
    private transient ParameterBlock paramBlock;
    private transient RenderingHints renderHints;
    protected transient PropertySource thePropertySource;
    private static Vector synthProps = new Vector();
    private transient Hashtable localProperties = null;
    private Hashtable synthProperties = null;
    private Vector volatilePropertyInfo = null;

    static {
        synthProps.addElement("image_width");
        synthProps.addElement("image_height");
        synthProps.addElement("image_min_x_coord");
        synthProps.addElement("image_min_y_coord");
    }

    public RenderedOp(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this(null, string, parameterBlock, renderingHints);
    }

    public RenderedOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.theRegistry = operationRegistry;
        this.operationName = string;
        this.paramBlock = parameterBlock == null ? new ParameterBlock() : parameterBlock;
        this.renderHints = renderingHints;
    }

    public synchronized void addNodeSource(Object object) {
        if (this.theImage == null) {
            this.paramBlock.addSource(object);
            this.thePropertySource = null;
        }
    }

    public synchronized void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        if (propertyGenerator == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderedOp6"));
        }
        this.createPropertySource();
        PropertySourceImpl propertySourceImpl = (PropertySourceImpl)this.thePropertySource;
        propertySourceImpl.addPropertyGenerator(propertyGenerator);
        this.createVolatilePropertyVector();
        if (!this.volatilePropertyInfo.contains(propertyGenerator)) {
            this.volatilePropertyInfo.add(propertyGenerator);
        }
    }

    public synchronized void addSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage7"));
        }
        this.createRendering();
        this.theImage.addSink(planarImage);
    }

    public synchronized void addSource(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        this.createRendering();
        this.theImage.addSource(planarImage);
    }

    public WritableRaster copyData() {
        this.createRendering();
        return this.theImage.copyData();
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.createRendering();
        return this.theImage.copyData(writableRaster);
    }

    public synchronized PlanarImage createInstance() {
        return this.createInstance(false);
    }

    private synchronized PlanarImage createInstance(boolean bl) {
        Object object;
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.setParameters(this.getParameters());
        int n = this.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            object = this.getNodeSource(n2);
            Object object2 = null;
            if (object instanceof RenderedOp) {
                RenderedOp renderedOp = (RenderedOp)object;
                object2 = bl || renderedOp.theImage != null ? renderedOp.getRendering() : renderedOp.createInstance();
            } else {
                object2 = object instanceof CollectionOp ? ((CollectionOp)object).getCollection() : (object instanceof RenderedImage || object instanceof Collection ? object : object);
            }
            parameterBlock.addSource(object2);
            ++n2;
        }
        object = this.getRegistry().create(this.operationName, parameterBlock, this.renderHints);
        if (object == null) {
            throw new RuntimeException(JaiI18N.getString("RenderedOp0"));
        }
        return object;
    }

    private synchronized void createLocalProperties() {
        if (this.localProperties == null) {
            this.localProperties = new Hashtable();
        }
    }

    private synchronized void createPropertySource() {
        if (this.thePropertySource == null) {
            this.thePropertySource = this.getRegistry().getPropertySource(this);
            if (this.volatilePropertyInfo != null) {
                PropertySourceImpl propertySourceImpl = (PropertySourceImpl)this.thePropertySource;
                int n = this.volatilePropertyInfo.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this.volatilePropertyInfo.get(n2);
                    if (e instanceof String) {
                        propertySourceImpl.suppressProperty((String)e);
                    } else if (e instanceof PropertyGenerator) {
                        propertySourceImpl.addPropertyGenerator((PropertyGenerator)e);
                    }
                    ++n2;
                }
            }
        }
    }

    private synchronized void createRendering() {
        if (this.theImage == null) {
            this.theImage = this.createInstance(true);
            this.setImageParameters(this.theImage);
        }
    }

    private synchronized void createSynthProperties() {
        if (this.synthProperties == null) {
            this.synthProperties = new Hashtable();
            this.synthProperties.put("image_width", new Integer(this.theImage.getWidth()));
            this.synthProperties.put("image_height", new Integer(this.theImage.getHeight()));
            this.synthProperties.put("image_min_x_coord", new Integer(this.theImage.getMinX()));
            this.synthProperties.put("image_min_y_coord", new Integer(this.theImage.getMinY()));
        }
    }

    private synchronized void createVolatilePropertyVector() {
        if (this.volatilePropertyInfo == null) {
            this.volatilePropertyInfo = new Vector();
        }
    }

    public byte getByteParameter(int n) {
        return this.paramBlock.getByteParameter(n);
    }

    public char getCharParameter(int n) {
        return this.paramBlock.getCharParameter(n);
    }

    public ColorModel getColorModel() {
        this.createRendering();
        return this.theImage.getColorModel();
    }

    public Raster getData() {
        this.createRendering();
        return this.theImage.getData();
    }

    public Raster getData(Rectangle rectangle) {
        this.createRendering();
        return this.theImage.getData(rectangle);
    }

    public double getDoubleParameter(int n) {
        return this.paramBlock.getDoubleParameter(n);
    }

    public float getFloatParameter(int n) {
        return this.paramBlock.getFloatParameter(n);
    }

    public int getHeight() {
        this.createRendering();
        return this.theImage.getHeight();
    }

    public int getIntParameter(int n) {
        return this.paramBlock.getIntParameter(n);
    }

    public long getLongParameter(int n) {
        return this.paramBlock.getLongParameter(n);
    }

    public int getMaxX() {
        this.createRendering();
        return this.theImage.getMaxX();
    }

    public int getMaxY() {
        this.createRendering();
        return this.theImage.getMaxY();
    }

    public int getMinX() {
        this.createRendering();
        return this.theImage.getMinX();
    }

    public int getMinY() {
        this.createRendering();
        return this.theImage.getMinY();
    }

    public Object getNodeSource(int n) {
        return this.paramBlock.getSource(n);
    }

    public int getNumParameters() {
        return this.paramBlock.getNumParameters();
    }

    public int getNumSources() {
        return this.paramBlock.getNumSources();
    }

    public Object getObjectParameter(int n) {
        return this.paramBlock.getObjectParameter(n);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ParameterBlock getParameterBlock() {
        return this.paramBlock;
    }

    public Vector getParameters() {
        return this.paramBlock.getParameters();
    }

    public synchronized Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage9"));
        }
        this.createPropertySource();
        string = string.toLowerCase();
        if (synthProps.contains(string)) {
            if (this.theImage == null) {
                this.createRendering();
            }
            this.createSynthProperties();
            return this.synthProperties.get(string);
        }
        if (this.localProperties != null && this.localProperties.containsKey(string)) {
            return this.localProperties.get(string);
        }
        return this.thePropertySource.getProperty(string);
    }

    public synchronized String[] getPropertyNames() {
        this.createPropertySource();
        String[] stringArray = this.thePropertySource.getPropertyNames();
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!vector.contains(stringArray[n2])) {
                    vector.addElement(stringArray[n2]);
                }
                ++n2;
            }
        }
        if (this.localProperties != null) {
            Enumeration enumeration = this.localProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (vector.contains(string = string.toLowerCase())) continue;
                vector.addElement(string);
            }
        }
        Enumeration enumeration = synthProps.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (vector.contains(string = string.toLowerCase())) continue;
            vector.addElement(string);
        }
        String[] stringArray2 = new String[vector.size()];
        Enumeration enumeration2 = vector.elements();
        int n = 0;
        while (enumeration2.hasMoreElements()) {
            stringArray2[n++] = (String)enumeration2.nextElement();
        }
        return stringArray2;
    }

    public synchronized OperationRegistry getRegistry() {
        if (this.theRegistry == null) {
            this.theRegistry = JAI.getDefaultInstance().getOperationRegistry();
        }
        return this.theRegistry;
    }

    public PlanarImage getRendering() {
        this.createRendering();
        return this.theImage;
    }

    public RenderingHints getRenderingHints() {
        return this.renderHints;
    }

    public SampleModel getSampleModel() {
        this.createRendering();
        return this.theImage.getSampleModel();
    }

    public short getShortParameter(int n) {
        return this.paramBlock.getShortParameter(n);
    }

    public synchronized Vector getSinks() {
        this.createRendering();
        return this.theImage.getSinks();
    }

    public PlanarImage getSource(int n) {
        this.createRendering();
        return this.theImage.getSource(n);
    }

    public Vector getSources() {
        return this.paramBlock.getSources();
    }

    public Raster getTile(int n, int n2) {
        this.createRendering();
        return this.theImage.getTile(n, n2);
    }

    public int getTileGridXOffset() {
        this.createRendering();
        return this.theImage.getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        this.createRendering();
        return this.theImage.getTileGridYOffset();
    }

    public int getTileHeight() {
        this.createRendering();
        return this.theImage.getTileHeight();
    }

    public int getTileWidth() {
        this.createRendering();
        return this.theImage.getTileWidth();
    }

    public Raster[] getTiles(Point[] pointArray) {
        this.createRendering();
        return this.theImage.getTiles(pointArray);
    }

    public int getWidth() {
        this.createRendering();
        return this.theImage.getWidth();
    }

    public void prefetchTiles(Point[] pointArray) {
        this.createRendering();
        this.theImage.prefetchTiles(pointArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        RenderingHintsProxy renderingHintsProxy = null;
        objectInputStream.defaultReadObject();
        this.paramBlock = (ParameterBlock)objectInputStream.readObject();
        renderingHintsProxy = (RenderingHintsProxy)objectInputStream.readObject();
        this.renderHints = renderingHintsProxy.getRenderingHints();
        if (objectInputStream.readBoolean()) {
            this.localProperties = (Hashtable)objectInputStream.readObject();
        }
        int n = 0;
        while (n < this.paramBlock.getNumSources()) {
            Object object2 = this.paramBlock.getSource(n);
            if (object2 instanceof SerializableRenderedImage) {
                object = PlanarImage.wrapRenderedImage((RenderedImage)object2);
                this.paramBlock.setSource(object, n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.paramBlock.getNumParameters()) {
            object = this.paramBlock.getObjectParameter(n2);
            if (object instanceof RasterProxy) {
                this.paramBlock.set(((RasterProxy)object).getRaster(), n2);
            } else if (object instanceof SerializableRenderedImage) {
                SerializableRenderedImage serializableRenderedImage = (SerializableRenderedImage)object;
                this.paramBlock.set(PlanarImage.wrapRenderedImage(serializableRenderedImage), n2);
            }
            ++n2;
        }
        if (this.getRegistry().getOperationDescriptor(this.operationName).isImmediate()) {
            this.createRendering();
        }
    }

    public synchronized boolean removeSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage7"));
        }
        this.createRendering();
        return this.theImage.removeSink(planarImage);
    }

    public synchronized boolean removeSource(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        this.createRendering();
        return this.theImage.removeSource(planarImage);
    }

    public synchronized void removeSources() {
        if (this.theImage == null) {
            this.paramBlock.removeSources();
            this.thePropertySource = null;
        }
    }

    public synchronized void setNodeSource(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        if (this.theImage == null) {
            this.paramBlock.setSource(object, n);
            this.thePropertySource = null;
        }
    }

    public synchronized void setOperationName(String string) {
        if (this.theImage == null) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.operationName = string;
            this.thePropertySource = null;
        }
    }

    public void setParameter(byte by, int n) {
        if (this.theImage == null) {
            this.paramBlock.set(by, n);
        }
    }

    public void setParameter(char c, int n) {
        if (this.theImage == null) {
            this.paramBlock.set(c, n);
        }
    }

    public void setParameter(double d, int n) {
        if (this.theImage == null) {
            this.paramBlock.set(d, n);
        }
    }

    public void setParameter(float f, int n) {
        if (this.theImage == null) {
            this.paramBlock.set(f, n);
        }
    }

    public void setParameter(int n, int n2) {
        if (this.theImage == null) {
            this.paramBlock.set(n, n2);
        }
    }

    public void setParameter(long l, int n) {
        if (this.theImage == null) {
            this.paramBlock.set(l, n);
        }
    }

    public void setParameter(Object object, int n) {
        if (this.theImage == null) {
            this.paramBlock.set(object, n);
        }
    }

    public void setParameter(short s, int n) {
        if (this.theImage == null) {
            this.paramBlock.set(s, n);
        }
    }

    public synchronized void setParameterBlock(ParameterBlock parameterBlock) {
        if (this.theImage == null) {
            this.paramBlock = parameterBlock == null ? new ParameterBlock() : parameterBlock;
            this.thePropertySource = null;
        }
    }

    public synchronized void setProperty(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage9"));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage17"));
        }
        string = string.toLowerCase();
        if (this.theImage != null) {
            throw new RuntimeException(JaiI18N.getString("RenderedOp3"));
        }
        if (synthProps.contains(string)) {
            throw new RuntimeException(JaiI18N.getString("RenderedOp4"));
        }
        this.createLocalProperties();
        this.localProperties.put(string, object);
    }

    public synchronized void setRegistry(OperationRegistry operationRegistry) {
        if (this.theImage == null) {
            this.theRegistry = operationRegistry;
            this.thePropertySource = null;
        }
    }

    public synchronized void setRenderingHints(RenderingHints renderingHints) {
        if (this.theImage == null) {
            this.renderHints = renderingHints;
            this.thePropertySource = null;
        }
    }

    public synchronized void setSource(PlanarImage planarImage, int n) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        this.createRendering();
        this.theImage.setSource(planarImage, n);
    }

    public synchronized void setSources(List list) {
        if (list == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage8"));
        }
        if (this.theImage == null) {
            this.paramBlock.removeSources();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                this.paramBlock.addSource(list.get(n2));
                ++n2;
            }
            this.thePropertySource = null;
        }
    }

    public synchronized void suppressProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage9"));
        }
        if (synthProps.contains(string = string.toLowerCase())) {
            throw new RuntimeException(JaiI18N.getString("RenderedOp5"));
        }
        this.createPropertySource();
        PropertySourceImpl propertySourceImpl = (PropertySourceImpl)this.thePropertySource;
        propertySourceImpl.suppressProperty(string);
        if (this.localProperties != null && this.localProperties.containsKey(string)) {
            this.localProperties.remove(string);
        }
        this.createVolatilePropertyVector();
        if (!this.volatilePropertyInfo.contains(string)) {
            this.volatilePropertyInfo.add(string);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        Object object2;
        ParameterBlock parameterBlock = this.paramBlock;
        boolean bl = false;
        int n = 0;
        while (n < parameterBlock.getNumSources()) {
            Object object3 = parameterBlock.getSource(n);
            if (object3 != null && !(object3 instanceof Serializable)) {
                if (!bl) {
                    parameterBlock = (ParameterBlock)this.paramBlock.clone();
                    bl = true;
                }
                if (object3 instanceof RenderedImage) {
                    object2 = new SerializableRenderedImage((RenderedImage)object3);
                    parameterBlock.setSource(object2, n);
                } else {
                    throw new RuntimeException(String.valueOf(object3.getClass().getName()) + JaiI18N.getString("RenderedOp1"));
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < parameterBlock.getNumParameters()) {
            object2 = parameterBlock.getObjectParameter(n2);
            if (object2 != null && !(object2 instanceof Serializable)) {
                if (!bl) {
                    parameterBlock = (ParameterBlock)this.paramBlock.clone();
                    bl = true;
                }
                if (object2 instanceof Raster) {
                    parameterBlock.set(new RasterProxy((Raster)object2), n2);
                } else if (object2 instanceof RenderedImage) {
                    object = (RenderedImage)object2;
                    parameterBlock.set(new SerializableRenderedImage((RenderedImage)object, true), n2);
                } else {
                    throw new RuntimeException(String.valueOf(object2.getClass().getName()) + JaiI18N.getString("RenderedOp2"));
                }
            }
            ++n2;
        }
        object2 = null;
        if (this.localProperties != null) {
            object = this.localProperties.keys();
            while (object.hasMoreElements()) {
                Object k = object.nextElement();
                Object v = this.localProperties.get(k);
                if (v instanceof Serializable) continue;
                if (object2 == null) {
                    object2 = (Hashtable)this.localProperties.clone();
                }
                ((Hashtable)object2).remove(k);
            }
            if (object2 == null) {
                object2 = this.localProperties;
            } else if (((Hashtable)object2).size() == 0) {
                object2 = null;
            }
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(parameterBlock);
        objectOutputStream.writeObject(new RenderingHintsProxy(this.renderHints));
        if (object2 != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(object2);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }
}

