DECLARE
CURSOR c_fks IS
  select 'alter table '||table_name||' drop constraint '||constraint_name||';' drop_fk_text
  from user_constraints where constraint_type = 'R';
CURSOR c_objects IS
 select 'drop '||object_type||' '||object_name drop_text
 from user_objects
   where object_type in ('TABLE','VIEW','SEQUENCE','PROCEDURE','FUNCTION',
  'PACKAGE', 'TYPE', 'SYNONYM', 'TRIGGER','JAVA CLASS','INDEXTYPE','OPERATOR')
   and object_name not like 'BIN$%';
BEGIN
 FOR c_rows IN c_fks
 LOOP
     BEGIN
       execute immediate(c_rows.drop_fk_text);
     EXCEPTION
       WHEN OTHERS THEN NULL;
     END;
 END LOOP;

 FOR i in 1 .. 10
 LOOP
 FOR c_rows IN c_objects
   LOOP
     BEGIN
       execute immediate(c_rows.drop_text);
     EXCEPTION
       WHEN OTHERS THEN NULL;
     END;
   END LOOP;
 END LOOP;
END;
/

DECLARE
  v_count INTEGER := 0;
BEGIN 
   FOR r IN
      (SELECT DISTINCT    'begin  dbms_java.dropjava ('''
                       || DBMS_JAVA.longname (object_name)
                       || '''); end;' AS command,
                       DBMS_JAVA.longname (object_name) as classname
                  FROM user_objects
                 WHERE object_type like 'JAVA%')
   LOOP
      EXECUTE IMMEDIATE r.command;
      v_count := v_count+1;
   END LOOP;
  --  DBMS_OUTPUT.put_line (v_count || ' object(s) were dropped.');
END;
/

purge recyclebin
/