/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.genotype.geli;

import edu.mit.broad.picard.genotype.geli.GeliException;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoods;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoodsCodec;
import edu.mit.broad.picard.util.AbstractIterator;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.IOUtil;

public class GeliFileReader
extends AbstractIterator<GenotypeLikelihoods>
implements Iterable<GenotypeLikelihoods>,
CloseableIterator<GenotypeLikelihoods> {
    private final GenotypeLikelihoodsCodec codec;

    public GeliFileReader(InputStream stream) {
        try {
            if (!BlockCompressedInputStream.isValidFile(IOUtil.toBufferedStream(stream))) {
                throw new GeliException("Invalid GELI file");
            }
            this.codec = new GenotypeLikelihoodsCodec(new DataInputStream(new BlockCompressedInputStream(stream)));
        }
        catch (IOException e) {
            throw new GeliException("Exception opening GELI stream", e);
        }
    }

    public GeliFileReader(File file) {
        try {
            if (!BlockCompressedInputStream.isValidFile(IOUtil.toBufferedStream(new FileInputStream(file)))) {
                throw new GeliException("Invalid GELI file");
            }
            this.codec = new GenotypeLikelihoodsCodec(new DataInputStream(new BlockCompressedInputStream(file)));
        }
        catch (IOException e) {
            throw new GeliException("Exception opening file " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public void close() {
        this.codec.close();
    }

    public SAMFileHeader getFileHeader() {
        return this.codec.getFileHeader();
    }

    @Override
    public CloseableIterator<GenotypeLikelihoods> iterator() {
        if (this.isIterating()) {
            throw new IllegalStateException("Iteration in progress");
        }
        return this;
    }

    @Override
    protected GenotypeLikelihoods advance() {
        return this.codec.decode();
    }
}

