/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.genotype.geli;

import edu.mit.broad.picard.genotype.geli.GeliFileReader;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoods;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.Genotype;
import org.broad.tribble.util.variantcontext.MutableGenotype;
import org.broad.tribble.util.variantcontext.VariantContext;
import org.broad.tribble.vcf.StandardVCFWriter;
import org.broad.tribble.vcf.VCFHeader;
import org.broad.tribble.vcf.VCFHeaderLine;

public class GeliToVCF
extends CommandLineProgram {
    public static final String VERSION = "1.0";
    @Option(shortName="O", doc="The output file name for the vcf, no extension is added (end yours in VCF)")
    public File OUTPUT;
    @Option(doc="A GELI file to access the samples genotypes from")
    public File GELI;
    @Option(doc="What we'd like to name the sample from the geli file, this is used as the sample name in the VCF")
    public String SAMPLE_NAME;
    private final Log log = Log.getInstance(GeliToVCF.class);

    public static void main(String[] args) {
        new GeliToVCF().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.GELI);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        GeliFileReader in = new GeliFileReader(this.GELI);
        StandardVCFWriter writer = new StandardVCFWriter(this.OUTPUT, false);
        HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
        headerLines.add(new VCFHeaderLine("CreatedBy", "PicardVCFToGeli1.0"));
        DateFormat dateFormatter = DateFormat.getDateInstance(3);
        Date today = new Date();
        headerLines.add(new VCFHeaderLine("CreatedOn", dateFormatter.format(today)));
        LinkedHashSet<String> sampleNames = new LinkedHashSet<String>();
        sampleNames.add(this.SAMPLE_NAME);
        VCFHeader header = new VCFHeader(headerLines, sampleNames);
        writer.writeHeader(header);
        long droppedRecords = 0L;
        long totalRecords = 0L;
        for (GenotypeLikelihoods geli : in) {
            VariantContext vc = this.convert(this.SAMPLE_NAME, geli);
            if (vc != null) {
                writer.add(vc, geli.getReferenceBase());
            } else {
                ++droppedRecords;
            }
            ++totalRecords;
        }
        this.log.info("Total GELI Records seen: " + totalRecords);
        this.log.info("Total GELI Records dropped due to inappropriate alleles: " + droppedRecords);
        writer.close();
        return 0;
    }

    VariantContext convert(String name, GenotypeLikelihoods geli) {
        if (!Allele.acceptableAlleleBases(String.valueOf((char)geli.getReferenceBase()), true)) {
            return null;
        }
        Allele refAllele = Allele.create(String.valueOf((char)geli.getReferenceBase()), true);
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        ArrayList<Allele> genotypeAlleles = new ArrayList<Allele>();
        alleles.add(refAllele);
        if (!Allele.acceptableAlleleBases(String.valueOf((char)geli.getBestGenotype().getAllele1()), false)) {
            return null;
        }
        Allele allele1 = Allele.create(String.valueOf((char)geli.getBestGenotype().getAllele1()), false);
        if (!alleles.contains(allele1) && !allele1.equals(refAllele, true)) {
            alleles.add(allele1);
        }
        if (allele1.basesMatch(refAllele)) {
            genotypeAlleles.add(refAllele);
        } else {
            genotypeAlleles.add(allele1);
        }
        if (!Allele.acceptableAlleleBases(String.valueOf((char)geli.getBestGenotype().getAllele2()), false)) {
            return null;
        }
        Allele allele2 = Allele.create(String.valueOf((char)geli.getBestGenotype().getAllele2()), false);
        if (!alleles.contains(allele2) && !allele2.equals(refAllele, true)) {
            alleles.add(allele2);
        }
        if (allele2.basesMatch(refAllele)) {
            genotypeAlleles.add(refAllele);
        } else {
            genotypeAlleles.add(allele2);
        }
        HashMap attributes = new HashMap();
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>();
        MutableGenotype call = new MutableGenotype(name, genotypeAlleles);
        call.putAttribute("DP", geli.getNumReads());
        call.setNegLog10PError(geli.getBestToSecondBestLod());
        genotypes.add(call);
        VariantContext vc = new VariantContext(name, geli.getSequenceName(), (long)geli.getPosition(), (long)geli.getPosition(), alleles, genotypes, (double)geli.getBestToReferenceLod(), null, attributes);
        return vc;
    }
}

