/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.picard.PicardException;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.RuntimeIOException;

public class IoUtil {
    public static void assertFileIsReadable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new PicardException("Cannot read non-existent file: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new PicardException("Cannot read file because it is a directory: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new PicardException("File exists but is not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertFileIsWritable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            File parent = file.getAbsoluteFile().getParentFile();
            if (!parent.exists()) {
                throw new PicardException("Cannot write file: " + file.getAbsolutePath() + ". " + "Neither file nor parent directory exist.");
            }
            if (!parent.isDirectory()) {
                throw new PicardException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent is not a directory.");
            }
            if (!parent.canWrite()) {
                throw new PicardException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent directory is not writable..");
            }
        } else {
            if (file.isDirectory()) {
                throw new PicardException("Cannot write file because it is a directory: " + file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                throw new PicardException("File exists but is not writable: " + file.getAbsolutePath());
            }
        }
    }

    public static void assertDirectoryIsWritable(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!dir.exists()) {
            throw new PicardException("Directory does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new PicardException("Cannot write to directory because it is not a directory: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new PicardException("Directory exists but is not writable: " + dir.getAbsolutePath());
        }
    }

    public static void assertFilesEqual(File f1, File f2) {
        try {
            int len1;
            if (f1.length() != f2.length()) {
                throw new PicardException("Files " + f1 + " and " + f2 + " are different lengths.");
            }
            FileInputStream s1 = new FileInputStream(f1);
            FileInputStream s2 = new FileInputStream(f2);
            byte[] buf1 = new byte[0x100000];
            byte[] buf2 = new byte[0x100000];
            while ((len1 = s1.read(buf1)) != -1) {
                int len2 = s2.read(buf2);
                if (len1 != len2) {
                    throw new PicardException("Unexpected EOF comparing files that are supposed to be the same length.");
                }
                if (Arrays.equals(buf1, buf2)) continue;
                throw new PicardException("Files " + f1 + " and " + f2 + " differ.");
            }
            s1.close();
            s2.close();
        }
        catch (IOException e) {
            throw new PicardException("Exception comparing files " + f1 + " and " + f2, e);
        }
    }

    public static void assertFileSizeNonZero(File file) {
        if (file.length() == 0L) {
            throw new PicardException(file.getAbsolutePath() + " has length 0");
        }
    }

    public static InputStream openFileForReading(File file) {
        try {
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IoUtil.openGzipFileForReading(file);
            }
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw new PicardException("Error opening file: " + file.getName(), ioe);
        }
    }

    public static InputStream openGzipFileForReading(File file) {
        try {
            return new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new PicardException("Error opening file: " + file.getName(), ioe);
        }
    }

    public static OutputStream openFileForWriting(File file) {
        return IoUtil.openFileForWriting(file, false);
    }

    public static OutputStream openFileForWriting(File file, boolean append) {
        try {
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IoUtil.openGzipFileForWriting(file, append);
            }
            return new FileOutputStream(file, append);
        }
        catch (IOException ioe) {
            throw new PicardException("Error opening file for writing: " + file.getName(), ioe);
        }
    }

    public static BufferedWriter openFileForBufferedWriting(File file, boolean append) {
        try {
            return new BufferedWriter(new FileWriter(file, append));
        }
        catch (IOException ioe) {
            throw new PicardException("Error opening file for writing: " + file.getName(), ioe);
        }
    }

    public static BufferedWriter openFileForBufferedWriting(File file) {
        try {
            return new BufferedWriter(new FileWriter(file, false));
        }
        catch (IOException ioe) {
            throw new PicardException("Error opening file for writing: " + file.getName(), ioe);
        }
    }

    public static OutputStream openGzipFileForWriting(File file, boolean append) {
        try {
            return new GZIPOutputStream(new FileOutputStream(file, append));
        }
        catch (IOException ioe) {
            throw new PicardException("Error opening file for writing: " + file.getName(), ioe);
        }
    }

    public static void copyStream(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = input.read(buffer)) > 0) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new PicardException("Exception copying stream", e);
        }
    }

    public static void copyFile(File input, File output) {
        try {
            FileInputStream is = new FileInputStream(input);
            FileOutputStream os = new FileOutputStream(output);
            IoUtil.copyStream(is, os);
            ((OutputStream)os).close();
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new PicardException("Error copying " + input + " to " + output, e);
        }
    }

    public static File[] getFilesMatchingRegexp(File directory, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return IoUtil.getFilesMatchingRegexp(directory, pattern);
    }

    public static File[] getFilesMatchingRegexp(File directory, final Pattern regexp) {
        return directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return regexp.matcher(name).matches();
            }
        });
    }

    public static void deleteDirectoryTree(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                IoUtil.deleteDirectoryTree(child);
            }
        }
        IOUtil.deleteFiles(fileOrDirectory);
    }

    public static File createTempDir(String prefix, String suffix) {
        try {
            File tmp = File.createTempFile(prefix, suffix);
            if (!tmp.delete()) {
                throw new PicardException("Could not delete temporary file " + tmp);
            }
            if (!tmp.mkdir()) {
                throw new PicardException("Could not create temporary directory " + tmp);
            }
            return tmp;
        }
        catch (IOException e) {
            throw new PicardException("Exception creating temporary directory.", e);
        }
    }

    public static BufferedReader openFileForBufferedReading(File file) throws IOException {
        return new BufferedReader(new InputStreamReader(IoUtil.openFileForReading(file)));
    }

    public static String makeFileNameSafe(String str) {
        return str.trim().replaceAll("[\\s!\"#$%&'()*/:;<=>?@\\[\\]\\\\^`{|}~]", "_");
    }

    public static String basename(File f) {
        String full = f.getName();
        int index = full.lastIndexOf(".");
        if (index > 0 && index > full.lastIndexOf(File.separator)) {
            return full.substring(0, index);
        }
        return full;
    }

    public static String getFullCanonicalPath(File file) {
        try {
            File f = file.getCanonicalFile();
            String canonicalPath = "";
            while (f != null && !f.getName().equals("")) {
                canonicalPath = "/" + f.getName() + canonicalPath;
                if ((f = f.getParentFile()) == null) continue;
                f = f.getCanonicalFile();
            }
            return canonicalPath;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error getting full canonical path for " + file + ": " + ioe.getMessage(), ioe);
        }
    }

    public static String readFully(InputStream in) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            StringBuilder builder = new StringBuilder(512);
            String line = null;
            while ((line = r.readLine()) != null) {
                if (builder.length() > 0) {
                    builder.append('\n');
                }
                builder.append(line);
            }
            return builder.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error reading stream", ioe);
        }
    }
}

