/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util.variantcontext;

public class GenotypeLikelihoods {
    double[] likelihoodsAsVector = null;
    String likelihoodsAsString = null;

    public GenotypeLikelihoods(String asString) {
        this.likelihoodsAsString = asString;
    }

    public GenotypeLikelihoods(double[] asVector) {
        this.likelihoodsAsVector = asVector;
    }

    public double[] getAsVector() {
        if (this.likelihoodsAsVector == null) {
            String[] strings = this.likelihoodsAsString.split(",");
            this.likelihoodsAsVector = new double[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                this.likelihoodsAsVector[i] = Double.parseDouble(strings[i]);
            }
        }
        return this.likelihoodsAsVector;
    }

    public String getAsString() {
        if (this.likelihoodsAsString == null) {
            boolean first = true;
            StringBuilder s = new StringBuilder();
            for (double l : this.likelihoodsAsVector) {
                if (!first) {
                    s.append(",");
                } else {
                    first = false;
                }
                s.append(String.format("%.2f", l));
            }
            this.likelihoodsAsString = s.toString();
        }
        return this.likelihoodsAsString;
    }

    public String toString() {
        return this.getAsString();
    }
}

