/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.vcf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.broad.tribble.Tribble;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broad.tribble.util.ParsingUtils;
import org.broad.tribble.util.PositionalStream;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.Genotype;
import org.broad.tribble.util.variantcontext.VariantContext;
import org.broad.tribble.vcf.VCFFilterHeaderLine;
import org.broad.tribble.vcf.VCFFormatHeaderLine;
import org.broad.tribble.vcf.VCFHeader;
import org.broad.tribble.vcf.VCFHeaderLine;
import org.broad.tribble.vcf.VCFHeaderVersion;
import org.broad.tribble.vcf.VCFInfoHeaderLine;
import org.broad.tribble.vcf.VCFWriter;

public class StandardVCFWriter
implements VCFWriter {
    protected VCFHeader mHeader = null;
    protected BufferedWriter mWriter;
    protected PositionalStream positionalStream = null;
    protected boolean filtersWereAppliedToContext = false;
    protected DynamicIndexCreator indexer = null;
    protected File indexFile = null;
    LittleEndianOutputStream idxStream = null;
    File location = null;

    public StandardVCFWriter(File location) {
        this(location, StandardVCFWriter.openOutputStream(location), true);
    }

    public StandardVCFWriter(File location, boolean enableOnTheFlyIndexing) {
        this(location, StandardVCFWriter.openOutputStream(location), enableOnTheFlyIndexing);
    }

    public StandardVCFWriter(File location, OutputStream output, boolean enableOnTheFlyIndexing) {
        this.location = location;
        if (enableOnTheFlyIndexing) {
            this.indexFile = Tribble.indexFile(location);
            try {
                this.idxStream = new LittleEndianOutputStream(new FileOutputStream(this.indexFile));
                this.indexer = new DynamicIndexCreator(IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
                this.indexer.initialize(location, this.indexer.defaultBinSize());
                this.positionalStream = new PositionalStream(output);
                output = this.positionalStream;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.mWriter = new BufferedWriter(new OutputStreamWriter(output));
    }

    public StandardVCFWriter(OutputStream output) {
        this.mWriter = new BufferedWriter(new OutputStreamWriter(output));
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.mHeader = header;
        try {
            this.mWriter.write("##" + VCFHeaderVersion.VCF4_0.getFormatString() + "=" + VCFHeaderVersion.VCF4_0.getVersionString() + "\n");
            for (VCFHeaderLine line : header.getMetaData()) {
                if (line.getKey().equals(VCFHeaderVersion.VCF4_0.getFormatString()) || line.getKey().equals(VCFHeaderVersion.VCF3_3.getFormatString()) || line.getKey().equals(VCFHeaderVersion.VCF3_2.getFormatString())) continue;
                if (line instanceof VCFFilterHeaderLine) {
                    this.filtersWereAppliedToContext = true;
                }
                this.mWriter.write("##");
                this.mWriter.write(line.toString());
                this.mWriter.write("\n");
            }
            this.mWriter.write("#");
            for (VCFHeader.HEADER_FIELDS field : header.getHeaderFields()) {
                this.mWriter.write(field.toString());
                this.mWriter.write("\t");
            }
            if (header.hasGenotypingData()) {
                this.mWriter.write("FORMAT");
                this.mWriter.write("\t");
                for (String sample : header.getGenotypeSamples()) {
                    this.mWriter.write(sample);
                    this.mWriter.write("\t");
                }
            }
            this.mWriter.write("\n");
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new TribbleException("IOException writing the VCF header to " + this.locationString(), e);
        }
    }

    private String locationString() {
        return this.location == null ? this.mWriter.toString() : this.location.getAbsolutePath();
    }

    @Override
    public void close() {
        try {
            this.mWriter.flush();
            this.mWriter.close();
            if (this.indexer != null) {
                Index index = this.indexer.finalizeIndex(this.positionalStream.getPosition());
                index.write(this.idxStream);
                this.idxStream.close();
            }
        }
        catch (IOException e) {
            throw new TribbleException("Unable to close " + this.locationString());
        }
    }

    protected static OutputStream openOutputStream(File location) {
        try {
            return new FileOutputStream(location);
        }
        catch (FileNotFoundException e) {
            throw new TribbleException("Unable to create VCF file at location: " + location);
        }
    }

    @Override
    public void add(VariantContext vc, byte refBase) {
        this.add(vc, refBase, false);
    }

    public void add(VariantContext vc, byte refBase, boolean refBaseShouldBeAppliedToEndOfAlleles) {
        if (this.mHeader == null) {
            throw new IllegalStateException("The VCF Header must be written before records can be added: " + this.locationString());
        }
        try {
            vc = VariantContext.createVariantContextWithPaddedAlleles(vc, refBase, refBaseShouldBeAppliedToEndOfAlleles);
            if (this.indexer != null) {
                this.indexer.addFeature(vc, this.positionalStream.getPosition());
            }
            HashMap<Allele, String> alleleMap = new HashMap<Allele, String>(vc.getAlleles().size());
            alleleMap.put(Allele.NO_CALL, ".");
            this.mWriter.write(vc.getChr());
            this.mWriter.write("\t");
            this.mWriter.write(String.valueOf(vc.getStart()));
            this.mWriter.write("\t");
            String ID = vc.hasAttribute("ID") ? vc.getAttributeAsString("ID") : ".";
            this.mWriter.write(ID);
            this.mWriter.write("\t");
            alleleMap.put(vc.getReference(), "0");
            String refString = vc.getReference().getDisplayString();
            this.mWriter.write(refString);
            this.mWriter.write("\t");
            if (vc.isVariant()) {
                Allele altAllele = vc.getAlternateAllele(0);
                alleleMap.put(altAllele, "1");
                String alt = altAllele.getDisplayString();
                this.mWriter.write(alt);
                for (int i = 1; i < vc.getAlternateAlleles().size(); ++i) {
                    altAllele = vc.getAlternateAllele(i);
                    alleleMap.put(altAllele, String.valueOf(i + 1));
                    alt = altAllele.getDisplayString();
                    this.mWriter.write(",");
                    this.mWriter.write(alt);
                }
            } else {
                this.mWriter.write(".");
            }
            this.mWriter.write("\t");
            if (!vc.hasNegLog10PError()) {
                this.mWriter.write(".");
            } else {
                this.mWriter.write(this.getQualValue(vc.getPhredScaledQual()));
            }
            this.mWriter.write("\t");
            String filters = vc.isFiltered() ? ParsingUtils.join(";", ParsingUtils.sortList(vc.getFilters())) : (this.filtersWereAppliedToContext || vc.filtersWereApplied() ? "PASS" : ".");
            this.mWriter.write(filters);
            this.mWriter.write("\t");
            TreeMap<String, String> infoFields = new TreeMap<String, String>();
            for (Map.Entry<String, Object> field : vc.getAttributes().entrySet()) {
                String outputValue;
                String key = field.getKey();
                if (key.equals("ID") || key.equals("_REFERENCE_BASE_FOR_INDEL_") || key.equals("_UNPARSED_GENOTYPE_MAP_") || key.equals("_UNPARSED_GENOTYPE_PARSER_") || (outputValue = StandardVCFWriter.formatVCFField(field.getValue())) == null) continue;
                infoFields.put(key, outputValue);
            }
            this.writeInfoString(infoFields);
            if (vc.hasAttribute("_UNPARSED_GENOTYPE_MAP_")) {
                this.mWriter.write("\t");
                this.mWriter.write(vc.getAttributeAsString("_UNPARSED_GENOTYPE_MAP_", ""));
            } else {
                ArrayList<String> genotypeAttributeKeys = new ArrayList<String>();
                if (vc.hasGenotypes()) {
                    genotypeAttributeKeys.add("GT");
                    for (String key : StandardVCFWriter.calcVCFGenotypeKeys(vc)) {
                        genotypeAttributeKeys.add(key);
                    }
                } else if (this.mHeader.hasGenotypingData()) {
                    genotypeAttributeKeys.add("GT");
                }
                if (genotypeAttributeKeys.size() > 0) {
                    String genotypeFormatString = ParsingUtils.join(":", genotypeAttributeKeys);
                    this.mWriter.write("\t");
                    this.mWriter.write(genotypeFormatString);
                    this.addGenotypeData(vc, alleleMap, genotypeAttributeKeys);
                }
            }
            this.mWriter.write("\n");
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the VCF object to " + this.locationString());
        }
    }

    private String getQualValue(double qual) {
        String s = String.format("%.2f", qual);
        if (s.endsWith(".00")) {
            s = s.substring(0, s.length() - ".00".length());
        }
        return s;
    }

    private void writeInfoString(Map<String, String> infoFields) throws IOException {
        if (infoFields.isEmpty()) {
            this.mWriter.write(".");
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : infoFields.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.mWriter.write(";");
            }
            String key = entry.getKey();
            this.mWriter.write(key);
            if (entry.getValue().equals("")) continue;
            int numVals = 1;
            VCFInfoHeaderLine metaData = this.mHeader.getInfoHeaderLine(key);
            if (metaData != null) {
                numVals = metaData.getCount();
            }
            if (numVals == -1) {
                numVals = 1;
            }
            if (numVals <= 0) continue;
            this.mWriter.write("=");
            this.mWriter.write(entry.getValue());
        }
    }

    private void addGenotypeData(VariantContext vc, Map<Allele, String> alleleMap, List<String> genotypeFormatKeys) throws IOException {
        for (String sample : this.mHeader.getGenotypeSamples()) {
            this.mWriter.write("\t");
            Genotype g = vc.getGenotype(sample);
            if (g == null) {
                this.mWriter.write("./.");
                continue;
            }
            this.writeAllele(g.getAllele(0), alleleMap);
            for (int i = 1; i < g.getPloidy(); ++i) {
                this.mWriter.write(g.genotypesArePhased() ? "|" : "/");
                this.writeAllele(g.getAllele(i), alleleMap);
            }
            ArrayList<String> attrs = new ArrayList<String>(genotypeFormatKeys.size());
            for (String key : genotypeFormatKeys) {
                String outputValue;
                int numInFormatField;
                String val;
                if (key.equals("GT")) continue;
                String string = val = g.hasAttribute(key) ? g.getAttribute(key) : ".";
                if (key.equals("GQ")) {
                    val = Math.abs(g.getNegLog10PError() - -1.0) < 1.0E-6 ? "." : this.getQualValue(Math.min(g.getPhredScaledQual(), 99.0));
                } else if (key.equals("FT")) {
                    val = g.isFiltered() ? ParsingUtils.join(";", ParsingUtils.sortList(g.getFilters())) : (g.filtersWereApplied() ? "PASS" : ".");
                }
                VCFFormatHeaderLine metaData = this.mHeader.getFormatHeaderLine(key);
                if (metaData != null && (numInFormatField = metaData.getCount()) > 1 && val.equals(".")) {
                    StringBuilder sb = new StringBuilder(".");
                    for (int i = 1; i < numInFormatField; ++i) {
                        sb.append(",");
                        sb.append(".");
                    }
                    val = sb.toString();
                }
                if ((outputValue = StandardVCFWriter.formatVCFField(val)) == null) continue;
                attrs.add(outputValue);
            }
            for (int i = attrs.size() - 1; i >= 0 && this.isMissingValue((String)attrs.get(i)); --i) {
                attrs.remove(i);
            }
            for (String s : attrs) {
                this.mWriter.write(":");
                this.mWriter.write(s);
            }
        }
    }

    private boolean isMissingValue(String s) {
        return StandardVCFWriter.countOccurrences(".".charAt(0), s) + StandardVCFWriter.countOccurrences(',', s) == s.length();
    }

    private void writeAllele(Allele allele, Map<Allele, String> alleleMap) throws IOException {
        String encoding = alleleMap.get(allele);
        if (encoding == null) {
            throw new TribbleException.InternalCodecException("Allele " + allele + " is not an allele in the variant context");
        }
        this.mWriter.write(encoding);
    }

    private static String formatVCFField(Object val) {
        String result;
        if (val == null) {
            result = ".";
        } else if (val instanceof Double) {
            result = String.format("%.2f", (Double)val);
        } else if (val instanceof Boolean) {
            result = (Boolean)val != false ? "" : null;
        } else if (val instanceof List) {
            result = StandardVCFWriter.formatVCFField(((List)val).toArray());
        } else if (val.getClass().isArray()) {
            int length = Array.getLength(val);
            if (length == 0) {
                return StandardVCFWriter.formatVCFField(null);
            }
            StringBuffer sb = new StringBuffer(StandardVCFWriter.formatVCFField(Array.get(val, 0)));
            for (int i = 1; i < length; ++i) {
                sb.append(",");
                sb.append(StandardVCFWriter.formatVCFField(Array.get(val, i)));
            }
            result = sb.toString();
        } else {
            result = val.toString();
        }
        return result;
    }

    private static List<String> calcVCFGenotypeKeys(VariantContext vc) {
        HashSet<String> keys = new HashSet<String>();
        boolean sawGoodQual = false;
        boolean sawGenotypeFilter = false;
        for (Genotype g : vc.getGenotypes().values()) {
            keys.addAll(g.getAttributes().keySet());
            if (g.hasNegLog10PError()) {
                sawGoodQual = true;
            }
            if (!g.isFiltered() || !g.isCalled()) continue;
            sawGenotypeFilter = true;
        }
        if (sawGoodQual) {
            keys.add("GQ");
        }
        if (sawGenotypeFilter) {
            keys.add("FT");
        }
        return ParsingUtils.sortList(new ArrayList(keys));
    }

    public static int countOccurrences(char c, String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            count += s.charAt(i) == c ? 1 : 0;
        }
        return count;
    }
}

