#! /bin/bash
# The Broad Institute
# SOFTWARE COPYRIGHT NOTICE AGREEMENT
# This software and its documentation are copyright 2009 by the
# Broad Institute/Massachusetts Institute of Technology. All rights are
# reserved.

# This software is supplied without any warranty or guaranteed support
# whatsoever. Neither the Broad Institute nor MIT can be responsible for its
# use, misuse, or functionality.

PROGNAME=`basename $0`
function usage () {
    echo "USAGE: $PROGNAME <new-branch-name>" >&2
    echo "Copies the current Picard trunk code into the given branch." >&2
}

set -e

while getopts "h" options; do
  case $options in
    h ) usage
          exit 1;;
    \? ) usage
         exit 1;;
    * ) usage
          exit 1;;

  esac
done
shift $(($OPTIND - 1))

if (( $# != 1 ))
 then echo "ERROR: Incorrect number of arguments." >&2
      usage
      exit 1
fi

source `dirname $0`/picard_defs.sh

if branch_exists $1
then echo "ERROR: Branch $1 already exists"
     exit 1
fi

echo Copying $SVNROOT/trunk to $SVNROOT/branches/$1
svn copy -m "branching for release" $SVNROOT/trunk $SVNROOT/branches/$1
