#!/bin/bash -l

reuse -q GridEngine-Seq_Prod

if [ $# -ne 1 ]
 then echo "USAGE: deadNodes.sh <email address>" >&2
      usage
      exit 1
fi

oneDayInSeconds=86400
today=`date +%s`
let oneDayAgo=$today-$oneDayInSeconds

i=1
tempfile=/seq/picardtemp/deadnodes.tmp
mkfifo $tempfile
qstat > $tempfile &
message=
while read LINE; do
        dateStr=${LINE:45:19}
        if [ $i -gt 2 ]; then
                jobDate=`date -d "$dateStr" +%s`
                if [ $oneDayAgo -gt $jobDate ]; then
                        message="${message}${LINE}\n"
                fi
        fi
        i=`expr $i + 1`
done < $tempfile

message=`echo -e $message`

rm $tempfile

mail -s "Day-old picard SGE jobs" $1 <<EOF
The following GridEngine jobs have been running for more than one day:

$message
EOF

