#! /bin/bash
# The Broad Institute
# SOFTWARE COPYRIGHT NOTICE AGREEMENT
# This software and its documentation are copyright 2009 by the
# Broad Institute/Massachusetts Institute of Technology. All rights are
# reserved.

# This software is supplied without any warranty or guaranteed support
# whatsoever. Neither the Broad Institute nor MIT can be responsible for its
# use, misuse, or functionality.

PROGNAME=`basename $0`

source `dirname $0`/picard_defs.sh

function usage () {
    echo "USAGE: $PROGNAME [options] <branch-name>" >&2
    echo "Deploy $BUILDROOT/<branch-name>/dist/deploy-picard.zip into $PICARDROOT and point $PICARDROOT/current at it." >&2
}

set -e

while getopts "h" options; do
  case $options in
    h ) usage
          exit 1;;
    \? ) usage
         exit 1;;
    * ) usage
          exit 1;;

  esac
done
shift $(($OPTIND - 1))

if (( $# != 1 ))
 then echo "ERROR: Incorrect number of arguments." >&2
      usage
      exit 1
fi

branch=$1

deploy_dir=$PICARDROOT/$branch

if [[ -e $deploy_dir ]]
then echo "ERROR: $deploy_dir already exists." >&2
     exit 1
fi

if [[ `whoami` != picard ]]
then echo "ERROR: must sudo -u picard to run this script." >&2
     exit 1
fi

zipfile=$BUILDROOT/$branch/Picard/dist/deploy-picard.zip

if [[ ! -e $zipfile ]]
then echo "ERROR: $zipfile does not exist." >&2
     exit 1
fi

mkdir $deploy_dir
cd $deploy_dir
unzip $zipfile
echo "Unzipped $zipfile."

cd $PICARDROOT
rm current
ln -s $deploy_dir current

chmod a+x $deploy_dir/bin/*.sh $deploy_dir/bin/*.jar $deploy_dir/bin/*.py $deploy_dir/3rd_party/*/*

cd $deploy_dir/bin
ln -s ../3rd_party/gatk/GATK-Picard.jar .
ln -s ../3rd_party/gatk/GenomeAnalysisTK.jar .

echo "Deployed successfully."
