#! /bin/bash
# The Broad Institute
# SOFTWARE COPYRIGHT NOTICE AGREEMENT
# This software and its documentation are copyright 2009 by the
# Broad Institute/Massachusetts Institute of Technology. All rights are
# reserved.

# This software is supplied without any warranty or guaranteed support
# whatsoever. Neither the Broad Institute nor MIT can be responsible for its
# use, misuse, or functionality.

PROGNAME=`basename $0`

source /broad/tools/scripts/useuse

reuse GCC-4.4

# Because of an unhandled error in dotkit, this must be after the use commands.
set -e

picarddir=/seq/software/picard/current
create_cache_only=0

function usage () {
    echo "USAGE: $PROGNAME -i <inputBam> -c <cacheDir> -o <outputFile> -r <referenceFasta> [ -t <tmpDir> ] [ -m <motifFile> ] [ -p <picardDir> ] " >&2
    echo "Run BadCoverage on given bam." >&2
    echo >&2
    echo "-l:                 Create cache only, do not process BAM." >&2
    echo "-i inputBam:        BAM to read (required unless -l)" >&2
    echo "-c cacheDir:        BadCoverage cache (required)" >&2
    echo "-o outputFile:      Where to write BadCoverage output (required unless -l)" >&2
    echo "-r referenceFasta:  (required)" >&2
    echo "-t tmpDir:          Obsolete argument -- ignored." >&2
    echo "-m motifFile:       Obsolete argument -- ignored." >&2
    echo "-p picardDir:       Location of Picard installation   Default: $picarddir" >&2
}

function check_arg_presence () {
    if [ "$1"x == x ]
        then echo "ERROR: $2 argument missing." >&2
        echo >&2
        usage;
        exit 1
    fi
}

while getopts ":t:i:m:c:o:r:p:l" options; do
  case $options in
    l ) create_cache_only=1;;
    t ) tmpdir=$OPTARG;;
    i ) inputBam=$OPTARG;;
    m ) motifs=$OPTARG;;
    c ) cachedir=$OPTARG;;
    o ) outputFile=$OPTARG;;
    r ) reference=$OPTARG;;
    p ) picarddir=$OPTARG;;
    h ) usage
          exit 1;;
    \? ) usage
         exit 1;;
    * ) usage
          exit 1;;
  esac
done
shift $(($OPTIND - 1))

if (( $create_cache_only == 0 )) 
then
    check_arg_presence "$inputBam" "-i"
    check_arg_presence "$outputFile" "-o"
    bam_args="BAM=$inputBam OUTPUT_FILE=$outputFile"
else
    bam_args=
fi
check_arg_presence "$cachedir" "-c"
check_arg_presence "$reference" "-r"

PATH=$PATH:$picarddir/3rd_party/samtools

$picarddir/3rd_party/arachne/BadCoverage REF_FASTA=$reference CACHE_DIR=$cachedir $bam_args
