#!/bin/bash

##############################################################################
# The following environment variable must be set before invoking this script, if java program needs to return results:
#     PEM_SCRIPT_RESULTS_FILE that specifies the file name into which script execution result should be written
##############################################################################

source /broad/tools/scripts/useuse
reuse R-2.8
reuse Java-1.6
ulimit -c 1000
# Increase address space to the maximum allowed
ulimit -v hard
umask 002

set -e

# default VM size 2GB
xmx=2g

# default no extra JVM args
jvmargs=


function usage () {
    echo "USAGE: runPicardCommand.sh [-m <xmx-value>] [-j <jvm-arg> ...] <jar-file> [param1=value1] [param2=value2]..." >&2
    echo >&2
    echo "Run executable jar file (-jar) that is in the same directory as this script." >&2
    echo >&2
    echo "-m <xmx-value>: Value to pass to JVM with -Xmx.  Default: 2g." >&2
    echo "-j <jvm-arg>: Additional jvm argument." >&2

}

PEM_SCRIPT_RESULTS_FILE_OPTION=
if [ "x$PEM_SCRIPT_RESULTS_FILE" != "x" ]
then
    PEM_SCRIPT_RESULTS_FILE_OPTION="PEM_SCRIPT_RESULTS_FILE=$PEM_SCRIPT_RESULTS_FILE"
fi

while getopts ":m:j:" options; do
  case $options in
    m ) if [ $OPTARG = "all" ]
        then
            allMinusOne=`free -m | awk '/Mem:/ {print $2}'`
            allMinusOne=$((allMinusOne - 1024))
            xmx="${allMinusOne}m"

        else
                xmx=$OPTARG
        fi
        echo "Java memory usage set: ${xmx}";;
    j ) jvmargs="$jvmargs $OPTARG";;
    h ) usage;;
    \? ) usage
         exit 1;;
    * ) usage
          exit 1;;

  esac
done
shift $(($OPTIND - 1))

if [ $# -eq 0 ]
then
    usage
    exit 1
fi


jar_name=$1
jar_path=`dirname $0`/$jar_name
shift

javabin_dir="/seq/software/picard/current/bin"
standard_classpath="$javabin_dir/sam-1.0.jar"

java -Xmx$xmx $jvmargs -cp $standard_classpath -jar "$jar_path" "$@" $PEM_SCRIPT_RESULTS_FILE_OPTION

sleep 15
