#! /bin/bash

source /home/radon00/prodinfo/.bashrc
TODAY=`date +"%A %B %d %Y %I:%M at %p"`
TODAY_SHORT=`date +%Y-%m-%d`
DIR=/seq/dirseq/picard_reports
FILENAME=${DIR}/hung_picard_workflow_report_${TODAY_SHORT}.xls
AGG_FILENAME=${DIR}/hung_picard_aggregation_workflow_report_${TODAY_SHORT}.xls
REANALYSIS_FILENAME=${DIR}/hung_picard_reanalysis_workflow_report_${TODAY_SHORT}.xls
EMAIL=picard@broadinstitute.org

cd $DIR
rm -f hung_picard_workflow_report.xls
sqlplus -S seq20/wmlalos\!@seqprod @/seq/software/picard/current/bin/hung_picard_workflow.sql
mv hung_picard_workflow_report.xls $FILENAME

rm -f hung_picard_reanalysis_workflow_report.xls
sqlplus -S seq20/wmlalos\!@seqprod @/seq/software/picard/current/bin/hung_picard_reanalysis_workflow.sql
mv hung_picard_reanalysis_workflow_report.xls $REANALYSIS_FILENAME

rm -f hung_picard_aggregation_workflow_report.xls
sqlplus -S seq20/wmlalos\!@seqprod @/seq/software/picard/current/bin/hung_picard_aggregation_workflow.sql
mv hung_picard_aggregation_workflow_report.xls $AGG_FILENAME

# See how many lines there are in the file (1 = header only)
LINES=`wc -l $FILENAME | awk '{print $1}'`
LINES2=`wc -l $AGG_FILENAME | awk '{print $1}'`
LINES3=`wc -l $REANALYSIS_FILENAME | awk '{print $1}'`

# Only output the report if there are actually rows in the file
if [[ "$LINES" == "1" && "$LINES2" == "1" && "LINES3" == "1" ]]
    then echo No data to report
else
REPORT=`cat $FILENAME`
RE_REPORT=`cat $REANALYSIS_FILENAME`
AGG_REPORT=`cat $AGG_FILENAME`
mail $EMAIL -s "Hung Picard Analysis Report" << EOT
Below is the report of Picard analyses that have been running for at least two days as of ${TODAY}.

Flowcell analyses:
${REPORT}

Flowcell re-analyses:
${RE_REPORT}

Aggregation analyses:
${AGG_REPORT}



EOT
fi

rm -f $FILENAME
rm -f $AGG_FILENAME
rm -f $REANALYSIS_FILENAME