#!/bin/bash

# Little script to create link from /seq/picard/XXXX -> /seq/picardnew/XXXX to aid transition
if [ $# -ne 1 ]
then
    echo "Usage: ./make_flowcell_link.sh <flowcell>"
    exit 1
fi

SOURCE=/seq/picard/$1
DEST=/seq/picardnew/$1

if [ -h $SOURCE ]
then
    echo "Symbolink link from $SOURCE to $DEST already exists.  Yay."
    exit 0
fi
	
if [ -d $SOURCE ]
then
    echo "Flowcell directory for $1 already exists on /seq/picard, cannot link."
    exit 2
fi

echo Creating link from $SOURCE to $DEST
ln -s $DEST $SOURCE
