#!/usr/bin/env python
# The Broad Institute
# SOFTWARE COPYRIGHT NOTICE AGREEMENT
# This software and its documentation are copyright 2008 by the
# Broad Institute/Massachusetts Institute of Technology. All rights are
# reserved.

# This software is supplied without any warranty or guaranteed support
# whatsoever. Neither the Broad Institute nor MIT can be responsible for its
# use, misuse, or functionality.
# $Header$
"""usage %prog [options]"""
from __future__ import division
import sys


def reverse_complement(strSeq):
    strSeq = list(strSeq)
    strSeq.reverse()
    strRet = ''
    for strBase in strSeq:
        if strBase == 'A':
            strComplement = 'T'
        elif strBase == 'T':
            strComplement = 'A'
        elif strBase == 'C':
            strComplement = 'G'
        elif strBase == 'G':
            strComplement = 'C'
        elif strBase == 'N':
            strComplement = 'N'
        else:
            raise Exception("Strange character in sequence: " + strBase)
        strRet += strComplement
    return strRet
            

def main(argv=None):
    if argv is None:
        argv = sys.argv

    for strLine in sys.stdin:
        strLine = strLine.rstrip('\n')
        print reverse_complement(strLine)

if __name__ == "__main__":
    sys.exit(main())
    
