package org.broadinstitute.cga.tools.seq;

import java.util.*;
import java.io.*;


public class BLASTreader {
	
	public static BufferedReader bf;
	public static String q = "Identities =";

	public BLASTreader(BufferedReader blastoutput) throws Exception{
		//System.out.println("BLASTreader made");
		bf = blastoutput;
	}

	public int read(long readlength, int mismatch) throws Exception {
		int match = 0;
		String line = bf.readLine();
		//System.out.println("Reading...");
		while(line != null){
			//System.out.println(line);
			int identities = line.indexOf("Identities =");
			if( identities != -1) {
				int slash = line.indexOf("/");
				int nmatch = Integer.parseInt(line.substring(identities+13,slash));	
				if((mismatch==0 && readlength-nmatch == 0) ||
					(mismatch==1 && readlength-nmatch <=10)) {
					System.out.println(nmatch+" out of "+readlength);	
					match = 1;	
				}
				break;
			}
			line = bf.readLine();
		}
		//if(match==0) System.out.println("No match to query");
		return(match);
	}
	
	public String multiread(long readlength, int mismatch) throws Exception {
		int nalign = 20;
		String line = bf.readLine();
		//System.out.println("Reading...");
		String fastas = "";
		while(line != null){
			String[] parts = line.split("\\s");
			//System.out.println("Mismatches are " + parts[4]);
			//System.out.println("readlength is " + readlength);
			//System.out.println("naligned is " + parts[3]);
			if(Integer.parseInt(parts[4]) <= mismatch && (readlength-Integer.parseInt(parts[3])) <= nalign) {
				fastas = fastas + parts[1] + " ";
				System.out.println("fastas is " + fastas);	
			}
			line = bf.readLine();
		}
		return(fastas);
	}

}
