package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.Fasta;
import org.broadinstitute.cga.tools.seq.BLASTreader;

import java.io.*;
import java.lang.*;
import java.util.*;

public class BlastAligner extends Aligner{

    public BlastAligner() {
    	System.out.println("blast aligner");
    }
    
    public BlastAligner(String fastaFile,String readFile, String alignFile, int mismatch) throws Exception {
	String s[] = fastaFile.split("/");
	fastaname = s[s.length-1];
	fastapath = dbstem+fastaname;
	readfile = readFile;
	alignfile = alignFile;
	mismatches = mismatch;
	loadFasta(fastaFile,mismatches);
    }
    
    
    public BlastAligner(String fastaFile, int allowOneMismatch) throws Exception {
	String s[] = fastaFile.split("/");
	fastaname = s[s.length-1];
	fastapath = dbstem+fastaname;
	loadFasta(fastaFile, allowOneMismatch);
    }
    
    // fastaFile = fasta file to make ncbi db out of
    // allowOneMismatch = if true, hashes one additional key for each single-base mismatch version
    //
    // align() returns 0 for queries where nothing is found

    private String fastaname; 
    private boolean ready = false;
    private String fastapath;
    public static BLASTreader breader;
    private String readfile = null;
    private String alignfile = null;
    private int mismatches = 1;
    private String dbstem = "/xchip/cga1/ehelman/Transposons/db/";

    
    public int align(String query) throws Exception {
	int pos = -1;
	int mismatches = 3;
	try {
		String command = "echo " + query + " | blastall -p blastn -d " + fastapath;
		//System.out.println(command);
		Process p = Runtime.getRuntime().exec(command);
		BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));

		BLASTreader breader = new BLASTreader(b);
		pos = breader.read(query.length(),mismatches);
	}
	catch(Exception ex) {ex.printStackTrace();}
		
	return(pos);
    }
    
    public String multialign(String queryfile) throws Exception {
		String fastas = "";
		OutputStream stdin = null;
		InputStream stderr = null;
		InputStream stdout = null;
		
		//int mismatches = 10;
		//System.out.println(query);
		//System.out.println(queryfile);
	try {
		String line;
		String tempalignfile = alignfile + ".partial";
		String command = "blastall -p blastn -i " + readfile + " -d " + fastapath + " -F F -m 8 -o " + tempalignfile ;
		System.out.println(command);
		
		Process p = Runtime.getRuntime().exec(command);
		
		stdin = p.getOutputStream ();
		 stderr = p.getErrorStream ();
		 stdout = p.getInputStream ();

		stdin.flush();
		stdin.close();

		BufferedReader brCleanUp = 
		        new BufferedReader (new InputStreamReader (stdout));
		while ((line = brCleanUp.readLine ()) != null) {
		        //System.out.println ("[Stdout] " + line);
		      }
		brCleanUp.close();
		
		brCleanUp = 
		        new BufferedReader (new InputStreamReader (stderr));
		while ((line = brCleanUp.readLine ()) != null) {
		      //System.out.println ("[Stderr] " + line);
		      }
		brCleanUp.close();
		
		//InputStream stderr = p.getErrorStream();
		//InputStreamReader isr = new InputStreamReader(stderr);
		//BufferedReader br = new BufferedReader(isr);
		
		p.waitFor();
	
		System.out.println("Done blasting!");
		File a = new File(tempalignfile);
		a.renameTo(new File(alignfile));
	//w.close();	
		fastas="done";
		}
	catch(Exception ex) {ex.printStackTrace();}
		
	return(fastas);
    }
    
    
    private void loadFasta(String fastaFile, int allowOneMismatch) throws Exception {

	// check if fasta db already exists
	File f = new File(fastapath+".nsq");
	if(!f.exists()) {
		System.out.println("Making fasta db at " + fastapath);
		String command = "formatdb -i " + fastaFile + " -p F";
		System.out.println(command);
		Process p = Runtime.getRuntime().exec(command);
		p.waitFor();
	} 
	//System.out.print("Fasta db exists at" + fastapath);
	
	ready = true;
    }

}    
