package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.BamGraspMine;
import org.broadinstitute.cga.tools.seq.BowtieAligner;
import net.sf.samtools.*;
//import net.sf.samtools.BAMFileWriter;
import java.io.*;
import java.lang.*;
import java.util.*;

public class FormatWeirds_Bowtie {
    
    private static final String usage =
	"Usage: FormatWeirds <BAMFilename> <BlacklistFilename> <TargetFasta> <Tumor> <Mismatches> "+
	                   "<Refdir> <Chromosome> <OutFilestem>\n"+
	"   <BAMFilename> = name of bam to preprocess\n"+
	"   <BlacklistFilename> = file listing blacklisted lanes e.g. '42ABC.1' -- or specify 'none'\n"+
	"   <TargetFasta> = fasta file with sequences to look for\n"+
	"   <Tumor> = tumor type\n"+
	"   <mismatches> = number of mismatches allowed for alignment\n"+
	"   <nalign> = minimum number of bases that align\n"+
	"   <Refdir> = reference genome assembly file" + 
	"   <Chromosome> = chromosome to process (1-24)\n"+      
	"   <OutFilestem> = filestem for output files\n";
    
    // parameters and input/output files
    
    private static String bamname = null;
    private static String blacklistname = null;
    private static String targetfasta = null;
    private static String tumor = null;
    private static String refdir = null;
    private static String readsdir = null;
    private static int percentident = 0;
    private static int nalign = 0;
    private static int chr = 0;
    private static int startpos = 0;
    private static int stoppos = 0;
    private static String outstem = null;
    private static double evalue = 1;

    private static BamGraspMine bam = null;
    private static BamGraspMine bam2 = null;
    //private static BAMFileWriter newbamfile = null;   
    private static SAMFileReader reader = null;
    private static SAMRecordIterator c = null;

    private static HashMap<String,ArrayList<String>> readhash = new HashMap<String,ArrayList<String>>();

    // info about current read
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    public static void main(String args[]) throws Exception {
	process_args(args);
	
	// open input file to create file of all reads
	open_input_file();

	int bsz = 10000;
	String path[] = outstem.split("/");
	String name = path[path.length-1];
	String fold = path[path.length-2];
	String arm = "p";
	if(startpos != 1) arm = "q";
	String outname3 = readsdir + name + ".chr" + chr + arm + ".reads.txt";

	String aligned = outstem +".chr" + chr + arm + ".reads.aligned.txt";
	File af = new File(aligned);
	if(af.exists()) System.out.println("Aligned file exists");
	else System.out.println("Aligned file does not exist");

	
	String outalignedparse = aligned + "parsed.txt";
	File afp = new File(outalignedparse);
	String alignedused = outalignedparse + ".used";
	File afpused = new File(alignedused);

	if(!afp.exists() && !afpused.exists()) {
	String outalignedparsetemp = outalignedparse + ".partial";
	BufferedWriter writeralignedparse = new BufferedWriter(new FileWriter(outalignedparsetemp),bsz);
	
        BufferedReader alignedreader = new BufferedReader(new FileReader(aligned));
	
	System.out.println("Beginning to read " + aligned + " and writing parsed file to " + outalignedparsetemp);

	boolean match = false;
	int oldcounter = -1;
	int printedremoved = -1;
	while(alignedreader.ready()) {
		
		String line = alignedreader.readLine();
		String[] alignedinfo = line.split("\t"); // Split blast results
		String[] id = alignedinfo[0].split("_"); // Split header
	    	String readname = id[1];
		String[] readinfo = id[0].split("\\|"); // Split readinfo
		int index = Integer.parseInt(readinfo[0]);

		//System.out.println(readname);
		//System.out.println(index);
		// id[0] = index|readname|chr|pos
		// id[1] = readname|chr|pos
		// id[2] = name
		// id[3] = alignedchr
		// id[4] = alignedstart
		// id[5] = clippedpos
		// id[6] = alignedend
		// id[7] = clipped_beginning (0) or clipped_end (1)
		// id[8] = strand
		// id[9] = mapqual
		// id[10] = whichread
		// alignedinfo[1] = strand
		// alignedinfo[2] = fasta
		// alignedinfo[3] = fasta_start
		// alignedinfo[4] = sequence
		// alignedinfo[5] = othermatches
		// alignedinfo[6] = mismatches
		String[] faminfo = alignedinfo[2].split("|");
		String family = faminfo[1];		


		if(index != oldcounter) {
			match = false;
		}	
		if(match == false) {
			// Check whether read passes nalign and percentident cutoff 
			int blastnalign = alignedinfo[4].length();
			String alignedfasta = alignedinfo[2];
			//System.out.println("Eval is " + blasteval);

			//if (blastnalign >= nalign && percent >= percentident) {
			//if ( blasteval <= evalue ) {
				//System.out.println("Blast eval qualifies");
				match = true;
				boolean pairdifffasta = false;
				ArrayList<String> val = new ArrayList<String>();
				//Check whether read name already in hash 
				//  If pairmate aligns to the same repetitive element, discard
				//  If pairmate aligns to different element - keep both!
				if (readhash.containsKey(readname)) {
					val = readhash.get(readname);
					String afasta = val.get(10);
					String[] afastafaminfo = afasta.split("\\|");
					String afastafam = afastafaminfo[1];
					//if(alignedfasta.equals(afasta)) {
					if(family.equals(afastafam)) {
						System.out.println("Removed "+family);
						readhash.remove(readname);
					} else { pairdifffasta = true; }
				}
				//Add to hash
				if (!readhash.containsKey(readname) || pairdifffasta == true ) {
					//System.out.println("adding");					
					for(int k = 1; k < id.length; k++) // adds readname|chr|pos,  name, alignedchr, alignedstart, clippedpos, alignedend, clipped_beginning (0) or clipped_end (1), strand, mapqual, whichread
						val.add(id[k]); 
					val.add(alignedinfo[2]); // fasta
					val.add(Integer.toString(alignedinfo[4].length())); // nalign
					int mismatches = 0;
					if(alignedinfo.length > 6) {
					    String seq = alignedinfo[6];
					    String[] misses = seq.split(",");
					    mismatches = misses.length;	
					}
					//System.out.println(mismatches);
					val.add(Integer.toString(mismatches)); // mismatches
					val.add(alignedinfo[3]); //fasta_start
					readhash.put(readname,val);
				}
			//}
				
		}
		oldcounter = index;
	}	

	System.out.println("Done parsing aligned; beginning to write singleton aligned");	
	System.out.println(readhash.values().size());
	// Write reads remaining in hash map
	writeralignedparse.write("ReadName\tName\tAlignedChromosome\tAlignedPosition\tClippedPosition\tAlignedEnd\tWhichClipped\tAlignedStrand\tAlignedQual\tAlignedWhichRead\tfasta\tnalign\tmismatches\tfastastart\n");
	for(ArrayList<String> value : readhash.values()) {
		//System.out.println(value.size());
		//int numelements = 16; //Columns in output	
		int numelements = value.size();
		
		if( numelements > 0 ) {
			for(int j=0; j < numelements-1; j++)
				writeralignedparse.write(value.get(j)+"\t");
		writeralignedparse.write(value.get(numelements-1)+"\n");
		//writeralignedparse.write("\n");
		}

	}
	writeralignedparse.flush();
	writeralignedparse.close();
	File f = new File(outalignedparsetemp);
	f.renameTo(new File(outalignedparse));
	System.out.println("Finished parsing to " + outalignedparse);
	
	
	//af.delete();
	}

	bam.close();
	bam2.close();
		    
	System.out.println("Finished.");
	
    } // end of main()
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void process_args(String args[]) throws Exception {
	if (args.length!=13) {
            System.out.print(usage);
            System.exit(1);
        }
	int a = 0;
	bamname = args[a++];
	blacklistname = args[a++];
	targetfasta = args[a++];
	tumor = args[a++];
	percentident = Integer.valueOf(args[a++]);
	nalign = Integer.valueOf(args[a++]);
	evalue = Double.valueOf(args[a++]);
	refdir = args[a++];
	readsdir = args[a++];
        chr = Integer.valueOf(args[a++]);
	if (chr<1 || chr>24) throw new Exception("chr should be 1-24");
	startpos = Integer.valueOf(args[a++]);
	stoppos = Integer.valueOf(args[a++]);
	outstem = args[a++];
    }
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void open_input_file() throws Exception {
	bam = new BamGraspMine(bamname,blacklistname,refdir);
	bam2 = new BamGraspMine(bamname,blacklistname,refdir);
	String seqname = bam.getChrName(chr);
	c = bam.reader.queryContained(seqname,startpos,stoppos);
    }
    
}
