package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.Fasta;
import org.broadinstitute.cga.tools.seq.BLASTreader;

import java.io.*;
import java.lang.*;
import java.util.*;

public class INCHWORMassembler extends Assembler{

    public INCHWORMassembler() {
    	System.out.println("Inchworm assembler");
    }
    public INCHWORMassembler(String readFile, String assemblePath) throws Exception {
    	readfile = readFile;
	assemblepath = assemblePath;
	//loadSeqs(13);
	}

    public INCHWORMassembler(String readFile, String assemblePath, int keyLength) throws Exception {
	readfile = readFile;
	assemblepath = assemblePath;
	keylen = keyLength;
	//loadSeqs(keylen);
    }

    private boolean ready = false;
    private String assemblepath;
    private String readfile;
    private int keylen;
    public String dbstem = "/xchip/cga1/ehelman/Transposons/db/";
    public String inchworm = "/xchip/cga/ehelman/Transposons/trinityrnaseq_r2012-10-05/Inchworm/bin/inchworm"; 
     
    public void assemble() throws Exception {
	try {
		String command = inchworm + " -K 25 --DS --reads " + readfile + " --run_inchworm > " + assemblepath;
		System.out.println(command);
		Process p = Runtime.getRuntime().exec(command);
		BufferedReader bin = new BufferedReader(new InputStreamReader(p.getInputStream()));
		BufferedWriter bow = new BufferedWriter(new FileWriter(assemblepath));
	
		String line = bin.readLine();
		while( line != null ){
			//bow.write("INCHWORM contigs \n");
			bow.write(line + "\n");
			line = bin.readLine();	
		}
		
		p.waitFor();
		bow.flush();
		System.out.println("Done Inchworming");
	}
	catch(Exception ex) {ex.printStackTrace();}
		
    }
    
}    
