package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.BamGraspMine;
import org.broadinstitute.cga.tools.seq.BowtieAligner;
import net.sf.samtools.*;
import net.sf.samtools.SAMFileWriterFactory;
//import net.sf.samtools.BAMFileWriter;
import java.io.*;
import java.lang.*;
import java.util.*;

public class MakeColor {
    
    private static final String usage =
	"Usage: MakeColor <BAMFilename> <BlacklistFilename> <TargetFasta> <Tumor> <Mismatches> "+
	                   "<Refdir> <Chromosome> <OutFilestem>\n"+
	"   <BAMFilename> = name of bam to preprocess\n"+
	"   <BlacklistFilename> = file listing blacklisted lanes e.g. '42ABC.1' -- or specify 'none'\n"+
	"   <TargetFasta> = fasta file with sequences to look for\n"+
	"   <Tumor> = tumor type\n"+
	"   <AllowOneMismatch> = if 1, will also hash every single-mismatch version of each key\n"+
	"   <Refdir> = reference genome assembly file" + 
	"   <Chromosome> = chromosome to process (1-24)\n"+      
	"   <OutFilestem> = filestem for output files\n";
    
    // parameters and input/output files
    
    private static String bamname = null;
    private static String blacklistname = null;
    private static String targetfasta = null;
    private static String tumor = null;
    private static String refdir = null;
    private static int mismatches = 0;
    private static int chr = 0;
    private static String outstem = null;

    private static BamGraspMine bam = null;
    private static BamGraspMine bam2 = null;
    //private static BAMFileWriter newbamfile = null;   
    private static SAMFileReader reader = null;
    private static SAMRecordIterator c = null;

    // info about current read
    
    private static int mate_chr=0, mate_start=0, this_chr=0, this_start=0;
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    public static void main(String args[]) throws Exception {
	
	process_args(args);
	
	// open input file to create file of all reads
	open_input_file();

	int bsz = 10000;
	String readstem = "/xchip/cga1/ehelman/Transposons/reads/";
	String path[] = outstem.split("/");
	String name = path[path.length-1];
	String fold = path[path.length-2];
	


	String aligned = outstem +".chr" + chr + ".weird.txt";
	File af = new File(aligned);
	if(af.exists()) System.out.println("Aligned file already exists");
	else System.out.println("Aligned file does not exist");

	
        BufferedReader b = new BufferedReader(new FileReader(aligned));
	File newbamfile = new File("/xchip/cga4/home/ehelman/testcolorbam.bam");
	SAMFileWriterFactory samfactory = new SAMFileWriterFactory();

	BAMFileWriter samwriter = (BAMFileWriter) samfactory.makeBAMWriter(bam.reader.getFileHeader(),true,newbamfile);

	// Start process of opening BAM file again to check for reads present in alignment file
	
	long rec = 0;
	long starttime = System.currentTimeMillis();
	long tic = starttime;
	long locMM = 0;
	final long recstep = 1000000;
	float last_sec = 0;

	int last_hit_start = -1;
	int hit_run_start = -1;
	int run_num_hits_f = 0;
    	int run_num_hits_r = 0;
	final int hit_merge_threshold = 1000;
	
	
	int counter = 0;	
	System.out.println("Starting to read bam again and alignment");
	while(b.ready() ){ 
	    String line = b.readLine();
	    String[] alignedinfo = line.split("\t");
	    String fastas = "";
	    int max = 0;
	    
	    while(c.hasNext() && b.ready()) {
		
		SAMRecord x = c.next();
	    	
	    	// keep only non-duplicate non-blacklisted paired reads
            	String seq = x.getReadString();
	    	
		if (x.getDuplicateReadFlag()) continue;
		if (x.getNotPrimaryAlignmentFlag()) continue;
	    	if (!x.getReadPairedFlag()) continue; 
		if (bam.isReadGroupBlacklisted(x.getAttribute("RG").toString())) continue;
		//if (seq.length() != 101) continue;
	   		
	   	SAMRecord x2 = (SAMRecord) x.clone();
	    
	    	this_chr = bam.read.chr;
	    	this_start = bam.read.start;
	   	int this_strand = bam.read.strand;
	   
	    	int numbads = 0;
	    	String[] oneline = alignedinfo[0].split("\t");
	    	/*String[] parts = oneline[0].split("-");
		String readname = parts[0];
		*/
		if(this_chr==Integer.parseInt(oneline[0]) && this_start==Integer.parseInt(oneline[2]) && this_strand==Integer.parseInt(oneline[1]))
			x2.setAttribute("YC", "Z:0,0,255");
		samwriter.addAlignment(x2);
		counter++;
		
		/*if( counter > Integer.parseInt(index[0]) ) break;
	    	
	    	if( Integer.parseInt(index[0]) != counter ) {
				
			counter++;
			continue;
	    	}


	    	//System.out.println("equal with bam seq " + seq + " and aligned " + line);
		//System.out.println(counter + " is aligned and weird");
			int pos = Integer.parseInt(alignedinfo[8]);
		//if( alignedinfo[1].equals("-") ) { pos = -pos; }
			
		//if(Double.valueOf(alignedinfo[10]) > 1) { counter++; break; }
			if (Integer.parseInt(alignedinfo[4]) > mismatches || Integer.parseInt(alignedinfo[3]) < 20) { 
				//newbamfile.writeAlignment(newbam);
				counter++; 
				break;}

			
			String fast = alignedinfo[1];
		
			SAMRecord mate = bam2.reader.queryMate(x);
			bam.parse(x,mate);
			if(bam.read.isbad()) {
		    	numbads++;
			}
			
			out.write(alignedinfo[0]+"\t"+this_chr+"\t"+bam.read.strand+"\t"+this_start+"\t"+
				bam.read.pairmatechr+"\t"+bam.read.pairmatestrand+"\t"+bam.read.pairmatestart+
				"\t"+bam.read.insertsize+"\t"+pos+"\t"+numbads+"\t"+fast+"\n");
			//newbam.setAttribute("YC", "Z:0,0,255");
			//newbamfile.writeAlignment(newbam);
			counter++;
			break;
		//counter++;
		*/
	    }	   
	}  // next record
	
	//newbamfile.setTextHeader(bam.getTextHeader());
	//newbamfile.setSortOrder(bam.getSortOrder(),false);
	
	// done
	samwriter.close();
	bam.close();
	bam2.close();
	//newbamfile.close();
	System.out.println("Finished.");
	
    } // end of main()
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void process_args(String args[]) throws Exception {
	if (args.length!=8) {
            System.out.print(usage);
            System.exit(1);
        }
	int a = 0;
	bamname = args[a++];
	blacklistname = args[a++];
	targetfasta = args[a++];
	tumor = args[a++];
	mismatches = Integer.valueOf(args[a++]);
	refdir = args[a++];
        chr = Integer.valueOf(args[a++]);
	if (chr<1 || chr>24) throw new Exception("chr should be 1-24");
	outstem = args[a++];
    }
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void open_input_file() throws Exception {
	bam = new BamGraspMine(bamname,blacklistname,refdir);
	bam2 = new BamGraspMine(bamname,blacklistname,refdir);
	String seqname = bam.getChrName(chr);
	c = bam.reader.queryContained(seqname,1,300000000);
    }
    
}
