## Load source code

args=(commandArgs(TRUE))

##args is now a list of character vectors
## First check to see if arguments are passed.
## Then cycle through each element of the list and evaluate the expressions.
if(length(args)==0){
    print("No arguments supplied.")
    }else{
        for(i in 1:length(args)){
	         eval(parse(text=args[[i]]))
	 }
     }
	print(tum)
	print(fasta)
	print(fastafile)
	print(samp)
	print(c)
	print(hg)
	print(outstem)
	print(codedir)
	print(percentident)
	print(nalign)
	print(queue)
	print(lsfdir)
	print(reffilesdir)
		
source("functions.R")


if(queue == "hour") queue = "hour -W 4:00"

## Run GetClusters
    tumclusters = paste(outstem,"-Tumor.clusters.chr",c,".txt",sep="")
    normclusters = paste(outstem,"-Normal.clusters.chr",c,".txt",sep="")
    if(!file.exists(tumclusters) | !file.exists(normclusters)) {
    
    	jobname = paste(samp,c,"GC",sep="_")
	scriptname = "GetClusters.R"
	script = scriptname

	cmd = paste("bsub -q hour -W 4:00 -J ",jobname," -o ",paste(lsfdir,tum,"_",fasta,"_",c,".out",sep="")," R CMD BATCH --no-save --no-restore '--args tum=\"",tum,"\" samp=\"",samp,"\" fasta=\"",fastafile,
        "\" blacklist=\"",blacklist,"\" c=\"",c,"\" hg=\"",hg,"\" codedir=\"",codedir,"\" refdir=\"",refdir,"\" readsdir=\"",readsdir,"\" outstem=\"",outstem,"\" nalign=\"",nalign,"\" percentident=\"",percentident,"\"' ",script," ", paste(lsfdir,scriptname,"_",tum,"_",c,".out",sep=""),sep="")

    	print(cmd)
       
       
     	system(cmd)

    	while ( system(paste("bjobs -J ", jobname, " | wc -l"), intern=T)>0 )
       	{
         	Sys.sleep(60)
        }

        print("Done clustering reads!")
    } else print("Candidate file already exists")



# Run Annotate
    annfile = paste(outstem,".chr",c,".candidates.txt",sep="")
    
    if(!file.exists(annfile)) {
    
    	jobname = paste(samp,fasta,c,"Ann",sep="_")
	scriptname = "Annotate.R"
	script = scriptname
	
	cmd = paste("bsub -q hour -W 4:00 -J ",jobname," -o ",paste(lsfdir,tum,"_",fasta,"_",c,".out",sep="")," R CMD BATCH --no-save --no-restore '--args tum=\"",tum,"\" samp=\"",samp,"\" fasta=\"",fastafile,
        "\" blacklist=\"",blacklist,"\" c=\"",c,"\" hg=\"",hg,"\" reffilesdir=\"",reffilesdir,"\" codedir=\"",codedir,"\" refdir=\"",refdir,"\" readsdir=\"",readsdir,"\" outstem=\"",outstem,"\" nalign=\"",nalign,"\" percentident=\"",percentident,"\"' ",script," ", paste(lsfdir,scriptname,"_",tum,"_",c,".out",sep=""),sep="")

    	print(cmd)
       
       
    	system(cmd)

    	while ( system(paste("bjobs -J ", jobname, " | wc -l"), intern=T)>0 )
       	{
         	Sys.sleep(60)
        }

        print("Done annotating clusters!")
    } else print("Annotated file already exists")


