package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.BamGraspMine;
import org.broadinstitute.cga.tools.seq.BowtieAligner;
import net.sf.samtools.*;
//import net.sf.samtools.BAMFileWriter;
import java.io.*;
import java.lang.*;
import java.util.*;

public class FormatWeirds {
    
    private static final String usage =
	"Usage: FormatWeirds <BAMFilename> <BlacklistFilename> <TargetFasta> <Tumor> <Mismatches> "+
	                   "<Refdir> <Chromosome> <OutFilestem>\n"+
	"   <BAMFilename> = name of bam to preprocess\n"+
	"   <BlacklistFilename> = file listing blacklisted lanes e.g. '42ABC.1' -- or specify 'none'\n"+
	"   <TargetFasta> = fasta file with sequences to look for\n"+
	"   <Tumor> = tumor type\n"+
	"   <mismatches> = number of mismatches allowed for alignment\n"+
	"   <nalign> = minimum number of bases that align\n"+
	"   <Refdir> = reference genome assembly file" + 
	"   <Chromosome> = chromosome to process (1-24)\n"+      
	"   <OutFilestem> = filestem for output files\n";
    
    // parameters and input/output files
    
    private static String bamname = null;
    private static String blacklistname = null;
    private static String targetfasta = null;
    private static String tumor = null;
    private static String refdir = null;
    private static String readsdir = null;
    private static int percentident = 0;
    private static int nalign = 0;
    private static int chr = 0;
    private static int startpos = 0;
    private static int stoppos = 0;
    private static String outstem = null;
    private static double evalue = 0.1;

    private static BamGraspMine bam = null;
    private static BamGraspMine bam2 = null;
    //private static BAMFileWriter newbamfile = null;   
    private static SAMFileReader reader = null;
    private static SAMRecordIterator c = null;

    private static HashMap<String,ArrayList<String>> readhash = new HashMap<String,ArrayList<String>>();

    // info about current read
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    public static void main(String args[]) throws Exception {
	process_args(args);
	
	// open input file to create file of all reads
	open_input_file();

	int bsz = 10000;
	String path[] = outstem.split("/");
	String name = path[path.length-1];
	String fold = path[path.length-2];
	String arm = "p";
	if(startpos != 1) arm = "q";
	String outname3 = readsdir + name + ".chr" + chr + arm + ".reads.txt";

	String aligned = outstem +".chr" + chr + arm + ".reads.aligned.txt";
	File af = new File(aligned);
	if(af.exists()) System.out.println("Aligned file exists");
	else System.out.println("Aligned file does not exist");

	
	String outalignedparse = aligned + "parsed.txt";
	File afp = new File(outalignedparse);
	String alignedused = outalignedparse + ".used";
	File afpused = new File(alignedused);

	if(!afp.exists() && !afpused.exists()) {
	String outalignedparsetemp = outalignedparse + ".partial";
	BufferedWriter writeralignedparse = new BufferedWriter(new FileWriter(outalignedparsetemp),bsz);
	
        BufferedReader alignedreader = new BufferedReader(new FileReader(aligned));
	
	System.out.println("Beginning to read " + aligned + " and writing parsed file to " + outalignedparsetemp);

	boolean match = false;
	int oldcounter = -1;
	int printedremoved = -1;
	while(alignedreader.ready()) {
		
		String line = alignedreader.readLine();
		String[] alignedinfo = line.split("\t"); // Split blast results
		String[] id = alignedinfo[0].split("~"); // Split header
	    	String readname = id[1];
		String[] readinfo = id[0].split("\\|"); // Split readinfo
		int index = Integer.parseInt(readinfo[0]);

		//  If pairmate is unalignable, discard
		if (id[8].equals("-1")) {
			//System.out.println(id[8]);
			continue;
		}
		//System.out.println(readname);
		//System.out.println(index);
		// id[0] = index|readname|chr|pos
		// id[1] = readname|chr|pos
		// id[2] = name
		// id[3] = alignedchr
		// id[4] = alignedstart
		// id[5] = alignedstrand
		// id[6] = alignedqual
		// id[7] = alignedwhichread
		// id[8] = uniquechr
		// id[9] = uniquestart
		// id[10] = uniquestrand
		// alignedinfo[1] = fasta
		// alignedinfo[2] = percentidentity
		// alignedinfo[3] = nalign
		// alignedinfo[4] = mismatches
		// alignedinfo[5] = gap opens
		// alignedinfo[6] = query_start
		// alignedinfo[7] = query_end
		// alignedinfo[8] = fasta_start
		// alignedinfo[9] = fasta_end
		// alignedinfo[10] = evalue
		// alignedinfo[11] = bit
		String[] faminfo = alignedinfo[1].split("|");
		String family = faminfo[1];		

		if(index != oldcounter) {
			match = false;
		}	
		if(match == false) {
			// Check whether read passes nalign and percentident cutoff 
			double percent = Double.valueOf(alignedinfo[2]);
			int blastnalign =Integer.parseInt(alignedinfo[3]);
			double blasteval = Double.valueOf(alignedinfo[10]);
			String alignedfasta = alignedinfo[1];
			//System.out.println("Eval is " + blasteval);

			//if (blastnalign >= nalign && percent >= percentident) {
			if ( blasteval <= evalue ) {
				//System.out.println("Blast eval qualifies");
				match = true;
				boolean pairdifffasta = false;
				ArrayList<String> val = new ArrayList<String>();
				//Check whether read name already in hash 
				//  If pairmate aligns to the same repetitive element, discard
				//  If pairmate aligns to different element - keep both!
				if (readhash.containsKey(readname)) {
					val = readhash.get(readname);
					String afasta = val.get(10);
					String[] afastafaminfo = afasta.split("\\|");
					String afastafam = afastafaminfo[1];
					System.out.println(afastafam);		
					//if(alignedfasta.equals(afasta)) {
					if(family.equals(afastafam)) {
						System.out.println("Removed "+family);
						readhash.remove(readname);
					} else { pairdifffasta = true; }
				}
				//Add to hash
				if (!readhash.containsKey(readname) || pairdifffasta == true ) {
					//System.out.println("adding");					
					for(int k = 1; k < id.length; k++) // Adds readname, name, alignedchrom, alignedpos, alignedstrand, alignedqual, alignedwhichread, uniquechr, uniquestart, uniquestrand
						val.add(id[k]); 
					val.add(alignedinfo[1]); // fasta
					val.add(alignedinfo[2]); // percent
					val.add(alignedinfo[3]); // nalign
					val.add(alignedinfo[8]); //fasta_start
					val.add(alignedinfo[9]); //fasta_stop
					val.add(alignedinfo[10]); //blast e-value
					readhash.put(readname,val);
				}
			}
				
		}
		oldcounter = index;
	}	

	System.out.println("Done parsing aligned; beginning to write singleton aligned");	
	System.out.println(readhash.values().size());
	// Write reads remaining in hash map
	writeralignedparse.write("ReadName\tName\tAlignedChromosome\tAlignedPosition\tAlignedStrand\tAlignedQual\tAlignedWhichRead\tUniquechr\tUniquestart\tUniquestrand\tfasta\tpercent\tnalign\tfastastart\tfastastop\tblasteval\n");
	for(ArrayList<String> value : readhash.values()) {
		//System.out.println(value.size());
		int numelements = 16; //Columns in output	
		int numreads = value.size() / numelements;
		
		if( numreads > 0 ) {
			for(int j=0; j < numelements-1; j++)
				writeralignedparse.write(value.get(j)+"\t");
		writeralignedparse.write(value.get(numelements-1)+"\n");
		//writeralignedparse.write("\n");
		}
		if(numreads == 2) {
			for(int j=numelements; j < value.size()-1; j++)
	                writeralignedparse.write(value.get(j)+"\t");
		writeralignedparse.write(value.get(value.size()-1)+"\n");
		//writeralignedparse.write("\n");
		}

	}
	writeralignedparse.flush();
	writeralignedparse.close();
	File f = new File(outalignedparsetemp);
	f.renameTo(new File(outalignedparse));
	System.out.println("Finished parsing to " + outalignedparse);
	
	
	af.delete();
	}

	bam.close();
	bam2.close();
		    
	System.out.println("Finished.");
	
    } // end of main()
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void process_args(String args[]) throws Exception {
	if (args.length!=13) {
            System.out.print(usage);
            System.exit(1);
        }
	int a = 0;
	bamname = args[a++];
	blacklistname = args[a++];
	targetfasta = args[a++];
	tumor = args[a++];
	percentident = Integer.valueOf(args[a++]);
	nalign = Integer.valueOf(args[a++]);
	evalue = Double.valueOf(args[a++]);
	refdir = args[a++];
	readsdir = args[a++];
        chr = Integer.valueOf(args[a++]);
	if (chr<1 || chr>24) throw new Exception("chr should be 1-24");
	startpos = Integer.valueOf(args[a++]);
	stoppos = Integer.valueOf(args[a++]);
	outstem = args[a++];
    }
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void open_input_file() throws Exception {
	bam = new BamGraspMine(bamname,blacklistname,refdir);
	bam2 = new BamGraspMine(bamname,blacklistname,refdir);
	String seqname = bam.getChrName(chr);
	c = bam.reader.queryContained(seqname,startpos,stoppos);
    }
    
}
