package org.broadinstitute.cga.tools.seq;

import org.broadinstitute.cga.tools.seq.BamGraspMine;
import org.broadinstitute.cga.tools.seq.BowtieAligner;
import net.sf.samtools.*;
//import net.sf.samtools.BAMFileWriter;
import java.io.*;
import java.lang.*;
import java.util.*;

public class  WriteReads {
    
    private static final String usage =
	"Usage: WriteReads <BAMFilename> <BlacklistFilename> <TargetFasta> <Tumor> <Mismatches> "+
	                   "<Refdir> <Chromosome> <OutFilestem>\n"+
	"   <BAMFilename> = name of bam to preprocess\n"+
	"   <BlacklistFilename> = file listing blacklisted lanes e.g. '42ABC.1' -- or specify 'none'\n"+
	"   <TargetFasta> = fasta file with sequences to look for\n"+
	"   <Tumor> = tumor type\n"+
	"   <AllowOneMismatch> = if 1, will also hash every single-mismatch version of each key\n"+
	"   <Refdir> = reference genome assembly file" + 
	"   <Chromosome> = chromosome to process (1-24)\n"+      
	"   <OutFilestem> = filestem for output files\n";
    
    // parameters and input/output files
    
    private static String bamname = null;
    private static String blacklistname = null;
    private static String targetfasta = null;
    private static String tumor = null;
    private static String refdir = null;
    private static String readsdir = null;
    private static int percentident = 0;
    private static int chr = 0;
    private static int startpos = 0;
    private static int stoppos = 0;
    private static String outstem = null;

    private static BamGraspMine bam = null;
    private static BamGraspMine bam2 = null;
    //private static BAMFileWriter newbamfile = null;   
    private static SAMFileReader reader = null;
    private static SAMRecordIterator c = null;

    // info about current read
    
    private static int mate_chr=0, mate_start=0, this_chr=0, this_start=0;
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    public static void main(String args[]) throws Exception {
	
	process_args(args);
	
	// open input file to create file of all reads
	open_input_file();

	int bsz = 10000;
	String path[] = outstem.split("/");
	String name = path[path.length-1];
	String fold = path[path.length-2];
	String arm;
	if(startpos == 1) arm = "p";
	else arm = "q";
	
	System.out.println(startpos);
	System.out.println(arm);
	String outname3 = readsdir + name + ".chr" + chr + arm + ".reads.txt";
	
	// Keep track of all reads and events seen
	int nDupFlag = 0;
	int nNotPrimFlag = 0;
	int nNotReadFlag = 0;
	int nBlackList = 0;
	int nReadLength = 0;
	int abnormreadlength = 0;
	
	File rf = new File(outname3);
	if(rf.exists()) System.out.println("Reads file exists");
	else {
		String outnametemp3 = outname3 + ".partial";
	
		BufferedWriter out3 = new BufferedWriter(new FileWriter(outnametemp3),bsz);
		System.out.println("Starting to read BAM file...");
		
		int counter = 0;
		while( c.hasNext() ) {
			SAMRecord x = c.next();
			counter++;	
			if (x.getDuplicateReadFlag()) {
				//System.out.println("duplicate read flag");
				nDupFlag++;
				continue; }
			if (x.getNotPrimaryAlignmentFlag()) {
				//System.out.println("not primary alignment flag");
				nNotPrimFlag++;
				continue; }
			if (!x.getReadPairedFlag()) {
				//System.out.println("not get read paired flag");
				nNotReadFlag++;
				continue; }
			if (bam.isReadGroupBlacklisted(x.getAttribute("RG").toString())) {
				//System.out.println("blacklisted");
				nBlackList++;
				continue; }
			
			String seq = x.getReadString();
			if(seq.length() != 101) {
				nReadLength++;
				abnormreadlength = seq.length();	
				//continue;
		 	}
			bam.parse(x);
			
			// If read is part of discordant pair, print its information and seq
			if (bam.read.isweird()) {
				// Abridge read name if too long
				String readname = x.getReadName();
				if(readname.length() > 60) {
					readname = readname.substring(0,59);
				}
				out3.write(">"+counter+"|"+readname+"|"+bam.read.chr+"|"+bam.read.start+"~"+
					readname+"|"+bam.read.chr+"|"+bam.read.start+"~"+
					readname+"~"+bam.read.chr+"~"+bam.read.start+"~"+bam.read.strand+"~"+bam.read.mapqual+"~"+bam.read.whichpairmate+"~"+
					bam.read.pairmatechr+"~"+bam.read.pairmatestart+"~"+bam.read.pairmatestrand+"\n");
				out3.write(seq + "\n");	
			}
		}
		System.out.println("nDupFlag is " + nDupFlag);
		System.out.println("nNotPrimFlag is " + nNotPrimFlag);
		System.out.println("nNotReadFlag is " + nNotReadFlag);
		System.out.println("nBlackList is " + nBlackList);
		System.out.println("nReadLength is " + nReadLength + " and abnormal read length example is " + abnormreadlength);
		System.out.println("totn is " + counter);
		bam.close();
		bam2.close();
		out3.close();
		File f1 = new File(outnametemp3);
		f1.renameTo(new File(outname3));
	}


	
    } // end of main()
    
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void process_args(String args[]) throws Exception {
	if (args.length!=11) {
            System.out.print(usage);
            System.exit(1);
        }
	int a = 0;
	bamname = args[a++];
	blacklistname = args[a++];
	targetfasta = args[a++];
	tumor = args[a++];
	percentident = Integer.valueOf(args[a++]);
	refdir = args[a++];
	readsdir = args[a++];
        chr = Integer.valueOf(args[a++]);
	if (chr<1 || chr>24) throw new Exception("chr should be 1-24");
	startpos = Integer.valueOf(args[a++]);
	System.out.println(startpos);
	stoppos = Integer.valueOf(args[a++]);
	System.out.println(stoppos);
	outstem = args[a++];
    }
    
    //////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////
    
    private static void open_input_file() throws Exception {
	bam = new BamGraspMine(bamname,blacklistname,refdir);
	bam2 = new BamGraspMine(bamname,blacklistname,refdir);
	String seqname = bam.getChrName(chr);
	c = bam.reader.queryContained(seqname,startpos,stoppos);
    }
    
}
