%       Copyright, February 2009, Ayellet Segre, Mark Daly, David Altshuler, Broad Institute, 7 Cambridge Center, Cambridge, MA 02142, USA
%
%       This code is part of the MAGENTA software package vs1.1 written in Matlab version R2009b, that tests for enrichment of multiple modest
%       genetic effects on a given complex disease or trait, in predefined sets of genes or loci.
%       The main code from which all functions are run is called: Run_MAGENTA_vs1_May10_2010.m
%
%       This software accompanies the paper:
%       Ayellet V. Segre, DIAGRAM Consortium, MAGIC investigators, Leif Groop, Vamsi K. Mootha, Mark J. Daly, and David Altshuler. Common Inherited Variation in
%       Mitochondrial Genes is not Enriched for Associations with Type 2 Diabetes or Related Glycemic Traits. In revision at PLoS Genetics, May 2010.
%
%       If your work benefits from the use of the MAGENTA  software package please cite the reference above.
%
%       For questions or comments please contact Ayellet Segre at asegre@broadinstitute.org. You can check for updates at: http://www.broadinstitute.org/mpg/magenta
%
%       Disclaimer: This software is distributed as is. The authors take no responsibility for any use or misuse.
%
%       Last updated: May 10, 2010
%

% Calculate number of hotspots that span each gene and their extended boundaries as defined by user in "Run_MAGENTA_vs1_May10_2010.m"

function [NumHotspots_per_gene]=Calculate_NumHotspots_per_gene_030911(GeneChrPos,hotspotPos,Gene_boundr_upstr,Gene_boundr_downstr,StrandOrient);

% Input variables:
% GeneChrPos: (1) chr num, (2) Tx start, bp, (3) Tx end, bp
% hotspotPos: (1) chr num, (2) left-hand side of hotspot (bp), (3) right-hand side of hotspot (bp), (4) hotspot width (kb)

[num_genes, x]=size(GeneChrPos);

NumHotspots_per_gene = zeros(num_genes,1);


for i=1:num_genes
	
	clear find_num_hotspots

	if (StrandOrient(i)==1)
		find_num_hotspots = find(hotspotPos(:,1)==GeneChrPos(i,1) & ( (hotspotPos(:,2) >= (GeneChrPos(i,2)-Gene_boundr_upstr) & hotspotPos(:,2) <= (GeneChrPos(i,3)+Gene_boundr_downstr)) | (hotspotPos(:,3) >= (GeneChrPos(i,2)-Gene_boundr_upstr) & hotspotPos(:,3) <= (GeneChrPos(i,3)+Gene_boundr_downstr) ) ));
	else
	        find_num_hotspots = find(hotspotPos(:,1)==GeneChrPos(i,1) & ((hotspotPos(:,2) >= (GeneChrPos(i,2)-Gene_boundr_downstr) & hotspotPos(:,2) <= (GeneChrPos(i,3)+Gene_boundr_upstr)) | (hotspotPos(:,3) >= (GeneChrPos(i,2)-Gene_boundr_downstr) & hotspotPos(:,3) <= (GeneChrPos(i,3)+Gene_boundr_upstr) ) ));
    	end

    if (find_num_hotspots)
     	NumHotspots_per_gene(i) = length(find_num_hotspots);
    end  
    
end


