%       Copyright, February 2009, Ayellet Segre, Mark Daly, David Altshuler, Broad Institute, 7 Cambridge Center, Cambridge, MA 02142, USA
%
%       This code is part of the MAGENTA software package vs1.1 written in Matlab version R2009b, that tests for enrichment of multiple modest
%       genetic effects on a given complex disease or trait, in predefined sets of genes or loci.
%       The main code from which all functions are run is called: Run_MAGENTA_vs1_May10_2010.m
%
%       This software accompanies the paper:
%       Ayellet V. Segre, DIAGRAM Consortium, MAGIC investigators, Leif Groop, Vamsi K. Mootha, Mark J. Daly, and David Altshuler. Common Inherited Variation in
%       Mitochondrial Genes is not Enriched for Associations with Type 2 Diabetes or Related Glycemic Traits. In revision at PLoS Genetics, May 2010.
%
%       If your work benefits from the use of the MAGENTA  software package please cite the reference above.
%
%       For questions or comments please contact Ayellet Segre at asegre@broadinstitute.org. You can check for updates at: http://www.broadinstitute.org/mpg/magenta
%
%       Disclaimer: This software is distributed as is. The authors take no responsibility for any use or misuse.
%
%       Last updated: May 10, 2010
%

% Calculate estimated number of linkage disequilibrium independent SNPs per gene region 

function [Num_Indep_SNPs_per_gene]=Calculate_NumIndepSNPsPerGene_030911(AllHumanGeneChrPos,PrunedSNPsChrPos,boundr_upstr,boundr_downstr);

Num_Indep_SNPs_per_gene = zeros(length(AllHumanGeneChrPos),1);

for i=1:length(AllHumanGeneChrPos)

 if (AllHumanGeneChrPos(:,6) ==1)

	% Count number of independent SNPs per gene
	Num_Indep_SNPs_per_gene(i) = length(find(PrunedSNPsChrPos(:,1)==AllHumanGeneChrPos(i,1) & PrunedSNPsChrPos(:,2) >= (AllHumanGeneChrPos(i,2)-boundr_upstr) & PrunedSNPsChrPos(:,2) <= (AllHumanGeneChrPos(i,3)+boundr_downstr) ));

 else 
        
        % Count number of independent SNPs per gene
        Num_Indep_SNPs_per_gene(i) = length(find(PrunedSNPsChrPos(:,1)==AllHumanGeneChrPos(i,1) & PrunedSNPsChrPos(:,2) >= (AllHumanGeneChrPos(i,2)-boundr_downstr) & PrunedSNPsChrPos(:,2) <= (AllHumanGeneChrPos(i,3)+boundr_upstr) ));

 end

end
