%       Copyright, February 2009, Ayellet Segre, Mark Daly, David Altshuler, Broad Institute, 7 Cambridge Center, Cambridge, MA 02142, USA
%
%       This code is part of the MAGENTA software package vs1.1 written in Matlab version R2009b, that tests for enrichment of multiple modest
%       genetic effects on a given complex disease or trait, in predefined sets of genes or loci.
%       The main code from which all functions are run is called: Run_MAGENTA_vs1_May10_2010.m
%
%       This software accompanies the paper:
%       Ayellet V. Segre, DIAGRAM Consortium, MAGIC investigators, Leif Groop, Vamsi K. Mootha, Mark J. Daly, and David Altshuler. Common Inherited Variation in
%       Mitochondrial Genes is not Enriched for Associations with Type 2 Diabetes or Related Glycemic Traits. In revision at PLoS Genetics, May 2010.
%
%       If your work benefits from the use of the MAGENTA  software package please cite the reference above.
%
%       For questions or comments please contact Ayellet Segre at asegre@broadinstitute.org. You can check for updates at: http://www.broadinstitute.org/mpg/magenta
%
%       Disclaimer: This software is distributed as is. The authors take no responsibility for any use or misuse.
%
%       Last updated: May 10, 2010
%


% Converting GWAS p-values to z-scores assuming a two-tailed test

function [GWAS_SNPChrNumPos_ZscorePval]=Converting_GWAS_TwoTailedPval_to_Zscores_082809(GWAS_SNPChrNumPos_Pval);

clear zscores pval
pval=GWAS_SNPChrNumPos_Pval(:,3);
% Calculate z-score from p-values, assuming a normal distribution
zscores=sqrt(chi2inv((1-pval),1)); % OR can use:  zscores=norminv(1-(p/2),0,1)

GWAS_SNPChrNumPos_ZscorePval=[GWAS_SNPChrNumPos_Pval(:,1:2) zscores GWAS_SNPChrNumPos_Pval(:,3)];

GWAS_SNPChrNumPos_ZscorePval(find(isinf(GWAS_SNPChrNumPos_ZscorePval(:,3))),3)=8.3; % if p-value<1e-16 assign z-score>8.2604 (this is limit of matlab)

