function [EnrichPval_multipleCutoffs,obs_num_above_cutoff,obs_fract_above_cutoff,record_rand_gs_num_output,record_rand_gs_fract_output]=GSEA_GWAS_eff_080610(Uncorr_score,Corr_score,top_percen_cutoffs,num_rounds,find_gene_set,score_signif_direct,choose_unique_genes,num_perm_limit);

%num_perm_limit=1000000; % stop at X gene set permutations

% find_gene_set = indeces of genes that belong to gene set
initial_num_genes_subset = length(find_gene_set);

original_num_rounds = num_rounds; % record starting number of permutations.

clear b2
b2=find_gene_set;

% Define gene scores for predefined gene setv
GeneSetScore = abs(Corr_score(b2));
Uncorr_score_geneset = abs(Uncorr_score(b2,:));

% remove genes with no score
Uncorr_score_geneset = Uncorr_score_geneset(find(~isnan(GeneSetScore)),:);

% remove genes with no score
GeneSetScore = GeneSetScore(find(~isnan(GeneSetScore)));


% sort all uncorrected gene scores (best SNP per gene p-values) according
% to significance of uncorrected score, and record chr num and pos of best SNP per gene

clear Uncorr_score_all_sorted_ind
[a, Uncorr_score_all_sorted_ind]= sort(abs(Corr_score),'ascend'); % sort SNPs according to corrected p-values

Sorted_all_uncorr_SNP_Chrpos = Uncorr_score(Uncorr_score_all_sorted_ind,1:2);

score =Corr_score(Uncorr_score_all_sorted_ind); % score of all genes
    
cutoffs=prctile(score,top_percen_cutoffs);  % e.g. meta: 0.0031    0.0423    0.2713    0.5355
gene_set_size = length(GeneSetScore);

% Find number/fraction of genes in input gene set that are above each given enrichment cutoff

clear obs_num_above_cutoff obs_fract_above_cutoff
for k=1:length(cutoffs)
           
    perc_cutoff=cutoffs(k);

    if (score_signif_direct==1)
       obs_num_above_cutoff(k) = length(find(GeneSetScore<=perc_cutoff));
       obs_fract_above_cutoff(k) = length(find(GeneSetScore<=perc_cutoff))/length(GeneSetScore);
    elseif (score_signif_direct==0)
       obs_num_above_cutoff(k) = length(find(GeneSetScore>=perc_cutoff));
       obs_fract_above_cutoff(k) = length(find(GeneSetScore>=perc_cutoff))/length(GeneSetScore);
    end

    count_num_permut_above_perc_cutoff(k) = 0;  % count number of randomly sampled gene sets that have the same number of genes or more that pass the given significance level

end % for each enrichment cutoff

fract_permut_above_perc_cutoff = ones(1,length(cutoffs))*(0.99/num_rounds); % lower bound; records fraction of randomly sampled gene sets with score as significant 
									  % or more than the observed gene set

record_rand_gs_num=zeros(original_num_rounds,length(cutoffs));  % number of genes in randomized gene set above each given cutoff
record_rand_gs_fract=zeros(original_num_rounds,length(cutoffs)); % fraction of genes in randomized gene set above each given cutoff
    
% Repeat GSEA calculation as long as the GSEA p-value is lower than 1/number_permutations
% or until you reach the upper limit of number of gene set permutations set by user.

while (find(fract_permut_above_perc_cutoff<=1/num_rounds))

% rand_geneset_score = nan(gene_set_size,num_rounds);  % number of genes in gene set by number of permutations

for i=1:num_rounds
        
    % randomly choose a gene set of x genes from all genes in genome assigned a score

    clear rand_geneset_ind Saved_gene_ind
    rand_geneset_ind = randsample([1:length(score)],gene_set_size);

   if (choose_unique_genes==1)
    clear Unique_genes_ind
    [a,Unique_genes_ind,j]=unique(Sorted_all_uncorr_SNP_Chrpos(rand_geneset_ind,1:2),'rows','first');
    
    Saved_gene_ind = rand_geneset_ind(Unique_genes_ind);
    
    while (length(Saved_gene_ind)<gene_set_size)
   
        remain_num =  gene_set_size - length(Saved_gene_ind); % number of genes that remain to be randomly sampled from genome
	remain_ind = setdiff([1:length(score)],Saved_gene_ind);    

        clear rand_geneset_ind_add
        rand_geneset_ind_add = randsample(remain_ind,remain_num);

        Updated_gene_ind = unique([Saved_gene_ind, rand_geneset_ind_add]);
        
        clear Unique_genes_ind
        [a,Unique_genes_ind,j]=unique(Sorted_all_uncorr_SNP_Chrpos(Updated_gene_ind,1:2),'rows','first');
        Saved_gene_ind = Updated_gene_ind(Unique_genes_ind);       
    
    end
   else
	Saved_gene_ind = rand_geneset_ind;
   end % if correct for physical proxomity (correcting for sharing between subset of genes of the same best SNP).
 
    clear rand_geneset_score;
    rand_geneset_score = score(Saved_gene_ind); % gene scores of randomly chose gene set of predetermined size

    % for each enrichment cutoff and for each gene set permutation, calculate and record fraction and number of genes above cutoff
    % and then test whether this fraction/number is larger or equal to that of the real gene set.

  for k=1:length(cutoffs)

    		perc_cutoff=cutoffs(k);

  		% count number of randomly sampled gene sets that have the same number of
		% genes or more that pass the given significance level


  if (score_signif_direct==1)
    
        if ( length(find(rand_geneset_score<=perc_cutoff)) >= obs_num_above_cutoff(k) )
            
            count_num_permut_above_perc_cutoff(k) =  count_num_permut_above_perc_cutoff(k) + 1; 
   
        end

	if (num_rounds<=10000)
	 record_rand_gs_num(i,k) = length(find(rand_geneset_score<=perc_cutoff));
         record_rand_gs_fract(i,k) = length(find(rand_geneset_score<=perc_cutoff)) / length(rand_geneset_score);
	end
      
  elseif (score_signif_direct==0)
  
        if ( length(find(rand_geneset_score>=perc_cutoff)) >= obs_num_above_cutoff(k) )
        
            count_num_permut_above_perc_cutoff(k) =  count_num_permut_above_perc_cutoff(k) + 1; 
   
        end

        if (num_rounds<=10000)
         record_rand_gs_num(i,k) = length(find(rand_geneset_score>=perc_cutoff));
         record_rand_gs_fract(i,k) = length(find(rand_geneset_score>=perc_cutoff)) / length(rand_geneset_score);
  	end

   end
      
    end % for each enrichment cutoff

  end % for each permutation run

   for k=1:length(cutoffs)
        fract_permut_above_perc_cutoff(k)=count_num_permut_above_perc_cutoff(k)/num_rounds;
   end

	num_rounds=num_rounds*100;

	if (num_rounds > num_perm_limit)

		% flag gene set with GSEA p-value less than 1/num_rounds
		fract_permut_above_perc_cutoff(find(fract_permut_above_perc_cutoff<=1/num_rounds)) = 999; 

	end

end % repeat until all GSEA p-values reach the resolution of number of permutations used or number of permutations reaches upper bound limit set by user

fract_permut_above_perc_cutoff(find(fract_permut_above_perc_cutoff==999))=0.99/(num_rounds/100); % lower bound

% matrices returned:
EnrichPval_multipleCutoffs=fract_permut_above_perc_cutoff;

record_rand_gs_num_output= record_rand_gs_num(1:original_num_rounds,:);
clear record_rand_gs_num;

record_rand_gs_fract_output=record_rand_gs_fract(1:original_num_rounds,:);
clear record_rand_gs_fract;
