%       Copyright, February 2009, Ayellet Segre, Mark Daly, David Altshuler, Broad Institute, 7 Cambridge Center, Cambridge, MA 02142, USA
%
%       This code is part of the MAGENTA software package vs1.1 written in Matlab version R2009b, that tests for enrichment of multiple modest
%       genetic effects on a given complex disease or trait, in predefined sets of genes or loci.
%       The main code from which all functions are run is called: Run_MAGENTA_vs1_May10_2010.m
%
%       This software accompanies the paper:
%       Ayellet V. Segre, DIAGRAM Consortium, MAGIC investigators, Leif Groop, Vamsi K. Mootha, Mark J. Daly, and David Altshuler. Common Inherited Variation in
%       Mitochondrial Genes is not Enriched for Associations with Type 2 Diabetes or Related Glycemic Traits. In revision at PLoS Genetics, May 2010.
%
%       If your work benefits from the use of the MAGENTA  software package please cite the reference above.
%
%       For questions or comments please contact Ayellet Segre at asegre@broadinstitute.org. You can check for updates at: http://www.broadinstitute.org/mpg/magenta
%
%       Disclaimer: This software is distributed as is. The authors take no responsibility for any use or misuse.
%
%       Last updated: May 10, 2010
%

function [RegressCorrGeneScores_pval, Residuals]=GeneScoreRegressCorr_122108(confounders,GeneScores);

[num_genes, num_confounders] = size(confounders);

cutoff=0.05; % include variables with p-value<=0.05 

% stepwise regression considering all variables on confounder matrix
[beta,se,pval,inmodel,stats,nextstep,history]=stepwisefit(confounders,abs(GeneScores))

% do stepwise regression considering only the significant variables
clear Residuals Resid_pval
Residuals = abs(GeneScores) - stats.intercept;

for j=1:num_confounders
    if (pval(j)<=cutoff) % include variables with p-value below cutoff
        Residuals = Residuals -  beta(j)*(confounders(:,j));
    end
end

% convert z-score residuals to p-values
RegressCorrGeneScores_pval = 1-normcdf(Residuals,mean(Residuals(find(~isnan(Residuals)))),std(Residuals(find(~isnan(Residuals)))));
%  p_from_z=1-chi2cdf(Z(:,1).^2, 1);
