require(EMMIXskew)

#######################
### Cluster samples ###
#######################


XCluster <- function(file) {
cat("read in user inputs",'\n')

input <- as.matrix(read.table(file,header=F,sep='\t',row.names=1))

ddir <- input[1,1]
samples <- input[2,]
samples <- as.numeric(strsplit(samples,',')[[1]])
samples <- samples[samples!=""]
markernums <- na.omit(as.numeric(input[3,]))
mnames <- input[4,]
subs = input[6,]
density = input[7,1]
g.min=as.numeric(input[8,1])
g.max=as.numeric(input[9,1])
downsample <- na.omit(as.numeric(input[10,1]))
	if (length(downsample)==0) {
		downsample = 100
	}
pops <- input[11,]
popclus <- input[12,]
output_name <- input[13,1]
outdir <- input[14,1]
dir.create(outdir)



initfile <- input[5,1]
	if (nchar(initfile) == 0) {
		init <- NULL
	}
	if (nchar(initfile)>0) {
        cat("read init file",'\n')
        init <- load(initfile)
        init <- obj
	}

################################

analysisdir = paste(output_name,"_MM_","Markers",paste(markernums,sep='',collapse=''),"_",g.min,"-",g.max,"Clusters",sep="")

setwd(outdir)
dir.create(analysisdir)
analysisdir <- paste(outdir,analysisdir,sep='/')

setwd(ddir)
datafiles = dir("./",pattern=".txt")
if (length(samples)>0) {
	datafiles <- datafiles[samples]
}


seed = 1111
step = 1
output.prefix = output_name

mixtureModel (wkdir=ddir,datafiles=datafiles, g.min=g.min, g.max=g.max, 
density=density, channels.to.cluster=markernums,
seed=seed,step=step,output.prefix = output.prefix,
analysisdir=analysisdir,
downsample=downsample,
init = init,
mnames=mnames,
populations = pops,
popclus = popclus,
taocut=0.95,
subs = subs
)

}

