
########################
### SD cutoff for 1D ###
########################

XSDcutoff <- function(file) {
	
input <- as.matrix(read.table(file,header=F,sep='\t',row.names=1))

#cdir <- input[1,1]
ddir <- input[1,1]
samples <- input[2,]
samples <- as.numeric(strsplit(samples,',')[[1]])
samples <- samples[samples!=""]
subs <- input[3,]
markernums <- as.numeric(input[4,])
markernames <- input[5,]
	markernames <- markernames[markernames!=""]
sds <- as.numeric(input[6,])
output_name <- input[7,1]
outdir <- input[8,1]
dir.create(outdir)


################################


analysisdir = paste(output_name,"SDcutoff",sep="_")

setwd(outdir)
dir.create(analysisdir)
analysisdir <- paste(outdir,analysisdir,sep='/')

setwd(ddir)
datafiles = dir("./",pattern=".txt")
if (length(samples)>0) {
	datafiles <- datafiles[samples]
}

sdCut(datadir=ddir,analysisdir,datafiles,subs,markernums,markernames,sds,output_name)

}