mixtureModel <- function(
wkdir,
datafiles, 
downsample = 100,
g.min=3,
g.max=5,
density = "normal", #{normal, t, skewn, skewt}
channels.to.cluster,
seed =1111, 
step = 1,
output.prefix, #<studyname_dataname>
analysisdir,
init,
mnames,
populations,
popclus,
taocut=0.95,
subs
){
setwd(wkdir)

g.range <- as.numeric(g.min):as.numeric(g.max) 
seed <- as.integer(seed)

num.channels.to.cluster = length(channels.to.cluster)

#run mixture model
dist = switch(density, "normal" = "mvn","t" = "mvt", "skewn" = "msn","skewt" = "mst")
runMixtureModel(datadir = wkdir,
downsample=downsample,
analysisdir = analysisdir,
datafiles,
dist=dist,
g=g.range,
dim2cluster=channels.to.cluster,
seed = seed,
step = step,
init = init,
output.prefix=output.prefix,
mnames=mnames,
populations=populations,
popclus=popclus,
taocut=0.95,
subs
)
}