subsum <- function(x){
	return(sum(x,na.rm=T))
}
########################################
### single dimensions sd cutoff ###
########################################

sdCut <- function(
datadir,
analysisdir,
datafiles,
subs,
markernums,
markernames,
sds,
output_name
) { #start function

for (i in 1:length(datafiles)) { #start one datafile
	
	setwd(datadir)
	dat.full <- read.table(datafiles[i],header=T,sep='\t')
	name <- strsplit(datafiles[i],"\\.txt")[[1]][1]
	name <- strsplit(datafiles[i],"\\.membership")[[1]][1]

	headers = names(dat.full)
	subs = subs[subs!=""]
	if (length(subs)>0) {
		sub = 1
		c.subs = c()
		for (s in 1:length(subs)) {
			c.sub = which(headers==subs[s])
			c.subs = c(c.subs,c.sub)		
		}
		subs.cluster = as.matrix(dat.full[,c.subs])
		annosum <- apply(subs.cluster,1,subsum)
		din = dat.full[which(annosum<1),]
		din.anno <- matrix(NA,nrow=nrow(din),ncol=length(markernums))
		din.out <- cbind(din,din.anno)
		dex = dat.full[which(annosum>=1),]
	}
	if (length(subs)==0) {
		sub = 0
		dex = dat.full
		din.out = NULL
	}
	
	dex.anno <- matrix(0,nrow=nrow(dex),ncol=length(markernums))
	for (c in 1:length(markernums)) {
		data <- dex[,markernums[c]]
		cut = sds[c]
		mean = mean(data)
		sd = sd(data)
		cutoff = mean + cut*sd
		anno1 <- which(data>=cutoff)
		dex.anno[anno1,c]=1
	}
	
	dex.out <- cbind(dex,dex.anno)	
	names(dex.out)=names(din.out)
	all.out <- rbind(dex.out,din.out)

	setwd(analysisdir)
	colnames <- c(headers,markernames)
	write.table(all.out,paste(name,"SDcutoff.txt",sep='.'),col.names=colnames,row.names=F,quote=F,sep='\t')

} #end one datafile



} #end function