#!/usr/bin/perl -w

use CGI qw(:standard);
print header;

print start_html(-title=>"PriSM Input Description",
		 -background=>"../../../seq_platform/specialprojects/PriSM_image/dna_6.jpg");

print "<br><h2 align=left>PriSM Input Description</h2>\n";

print "<br><p><b>Primer size (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Maximum number of nucleotides in the primer<br>&nbsp;&nbsp;&nbsp;Default: 20</p>\n";

print "<p><b>Primer overlap length (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Number of bases primers can overlap by in design phase<br>&nbsp;&nbsp;&nbsp;Default: 19</p>\n";

print "<p><b>Minimum GC percentage</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Minimum GC content of each primer<br>&nbsp;&nbsp;&nbsp;Default: 45</p>\n";

print "<p><b>Maximum GC percentage</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Maximum GC content of each primer<br>&nbsp;&nbsp;&nbsp;Default: 55</p>\n";

print "<p><b>Minimum Tm (C)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Lower limit of primer melting temperatures<br>&nbsp;&nbsp;&nbsp;Default: 56</p>\n";

print "<p><b>Maximum Tm (C)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Upper limit of primer melting temperatures<br>&nbsp;&nbsp;&nbsp;Default: 65</p>\n";

print "<p><b>Maximum number of degenerate bases allowed (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Maximum number of IUPAC bases allowed in final primer<br>&nbsp;&nbsp;&nbsp;Default: 3</p>\n";

print "<p><b>Maximum number of monomer bases allowed (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Maximum Number of bases in a mononucleotide run within a primer<br>&nbsp;&nbsp;&nbsp;Default: 4</p>\n";

print "<p><b>Primer concentration (nM)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Concentration at which primer will be synthesized (used for Tm calculation)<br>&nbsp;&nbsp;&nbsp;Default: 50</p>\n";

print "<p><b>Salt concentration (mM)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Salt concentration in primer stock (used for Tm calculation)<br>&nbsp;&nbsp;&nbsp;Default: 50</p>\n";

print "<p><b>Valid base minimum frequency</b><br>\n";
print "&nbsp;&nbsp;&nbsp;The minimum frequency of a given base at a given position in the alignment at which the base is considered valid<br>&nbsp;&nbsp;&nbsp;Default: 0.1</p>\n";

print "<p><b>Valid degenerate maximum frequency</b><br>\n";
print "&nbsp;&nbsp;&nbsp;The upper limit of conservation in an alignment at a given position, above which the base is called for the majority at that position. Below this, a dengenerate base is called.<br>&nbsp;&nbsp;&nbsp;Default: 0.85</p>\n";

print "<p><b>Maximum self-complement bases allowed within a single primer (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Maximum number of bases within a primer that are self-complimentary<br>&nbsp;&nbsp;&nbsp;Default: 10</p>\n";


print "<p><b>Valid gap minimum frequency</b><br>\n";
print "&nbsp;&nbsp;&nbsp;The frequency of genomes within an alignment that must contain a gap at a given position for that gap to be represented in the consensus<br>&nbsp;&nbsp;&nbsp;Default: 0.8</p>\n";

print "<p><b>Primer blast minimum hit frequency</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Minimum frequency of hits for a given primer back to the genomes in the alignment<br>&nbsp;&nbsp;&nbsp;Default: 0.8</p>\n";

print "<p><b>Maximum amplicon length (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Upper limit for amplified product length<br>&nbsp;&nbsp;&nbsp;Default: 900</p>\n";

print "<p><b>Minimum amplicon length (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Lower limit for amplified product length<br>&nbsp;&nbsp;&nbsp;Default: 500</p>\n";

print "<p><b>Amplicon overlap length (bp)</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Desired overlap between adjacent amplicons in the panel<br>&nbsp;&nbsp;&nbsp;Default: 100</p>\n";

print "<p><b>Maximum degenerate primer combination</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Maximum number of unique primer combinations as determined by the permutations of degenerate bases within a primer<br>&nbsp;&nbsp;&nbsp;Default: 8</p>\n";

print "<p><b>Maximum complement bases in primer pair</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Maximum number of bases that can be complimentary between a forward and reverse primer in a pair<br>&nbsp;&nbsp;&nbsp;Default: 15</p>\n";

print "<p><b>Genome name</b><br>\n";
print "&nbsp;&nbsp;&nbsp;Single word (no spaces or symbols) to indicate template. This title will appear in primer name.</p>\n";

print "<p><b>Upload genome multi-fasta file <i>(required)</i></b><br>\n";
print "&nbsp;&nbsp;&nbsp;The genome multi-fasta file contains the sequence of all genomes of your project in fasta format. The genome fasta file is the input file when you use MUSCLE or CLUSTALW to generate alignment file. No space in file name. For example, HIV_AE.fasta</p>\n";

print "<p><b>Upload alignment file <i>(Optional)</i></b><br>\n";
print "&nbsp;&nbsp;&nbsp;The multiple alignment file is the output of MUSCLE, or CLUSTALW. PriSM only accepts the output from MUSCLE and CLUSTALW. The file should be named with file extension \".muscle\" or \".aln\". No space in file name. For example, HIV_AE.muscle, HIV_C.aln<br>\n";
print "&nbsp;&nbsp;&nbsp;If user does not upload alignment file, PriSM will use MUSCLE to generate alignment using MUSCLE default conditions.</p>\n";


print "<br><br><img src=\"../../../seq_platform/specialprojects/PriSM_image/broadlogo2.jpg\" width=\"92\" height=\"30\"><font size=2 face=\"Times\" color=\"#808080\">Copyright \&#169 Special Project Group, Broad Institute of MIT and Harvard &nbsp;&nbsp;&nbsp;&nbsp;Last Modified 06-05-2009</font>\n";



print end_html;
