/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  bidirectional_kmer_incidence_collector.hpp
 *
 *  Class for collecting the incidence of all k-mers in a set of
 *  sequences into a BidirectionalKmerIncidenceMap.
 */


#ifndef BIDIRECTIONAL_KMER_INCIDENCE_COLLECTOR_H
#define BIDIRECTIONAL_KMER_INCIDENCE_COLLECTOR_H


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "kmer_encoder.hpp"
#include "motif_incidence_map.hpp"
#include "kmer_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"


class BidirectionalKmerIncidenceCollector : public KmerIncidenceCollector {
public:
	
	BidirectionalKmerIncidenceCollector( KmerEncoder& kmer_encoder ) : KmerIncidenceCollector( kmer_encoder ) {}
	virtual ~BidirectionalKmerIncidenceCollector() {}
	
	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs );

protected:
	
};


#endif // BIDIRECTIONAL_KMER_INCIDENCE_COLLECTOR_H
