/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  bidirectional_pwm_motif_incidence_collector.cpp
 *
 *  Class for collecting the incidence of a set of "position weight matrix"
 *  motifs on the + and - strands in a set of sequences into a MotifIncidenceMap.
 */


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "pwm_motif.hpp"
#include "motif_incidence_map.hpp"
#include "pwm_motif_incidence_map.hpp"
#include "motif_incidence_collector.hpp"
#include "named_motif_incidence_collector.hpp"
#include "pwm_motif_incidence_collector.hpp"
#include "bidirectional_pwm_motif_incidence_collector.hpp"


MotifIncidenceMap*
BidirectionalPWMMotifIncidenceCollector::collectIncidence( const SequenceVector& seqs )
{
	return PWMMotifIncidenceCollector::collectIncidence( seqs );
}


BidirectionalPWMMotifIncidenceCollector::BidirectionalPWMMotifIncidenceCollector( PWMMotifVector& motif_v )
	: PWMMotifIncidenceCollector( motif_v )
{
	for( PWMMotifVector::const_iterator iter = motifVector.begin(); iter != motifVector.end(); ++iter ) {
		PWMMotif* tmp = new PWMMotif( **iter );
		tmp->reverseComplement();
		revcMotifVector.push_back( tmp );
	}
}


BidirectionalPWMMotifIncidenceCollector::~BidirectionalPWMMotifIncidenceCollector()
{
	deleteVectorElements( revcMotifVector );
}


void
BidirectionalPWMMotifIncidenceCollector::setMotifNames( PWMMotifVector& motifs, PWMMotifIncidenceMap* m )
{
	svector motifNames( motifs.size() );
	for( unsigned int i = 0; i < motifs.size(); ++i ) {
		motifNames[ i ] = motifs[ i ]->getName();
		motifNames[ i ] += "_+/-";
	}
	NamedMotifIncidenceCollector::setMotifNames( motifNames, m );
}


void
BidirectionalPWMMotifIncidenceCollector::collectIncidence( MotifIncidenceMap::MotifNumber motifNum, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m )
{
	PWMMotifIncidenceCollector::collectIncidence( motifNum, motifVector, seqNum, seqs, m );
	PWMMotifIncidenceCollector::collectIncidence( motifNum, revcMotifVector, seqNum, seqs, m );
}
