/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  binomial_gene_set_motif_enrichment.hpp
 *
 *  Class for comparing the incidence of motifs in a given gene set to
 *  background using a binomial null model.
 */


#ifndef BINOMIAL_GENE_SET_MOTIF_ENRICHMENT_H
#define BINOMIAL_GENE_SET_MOTIF_ENRICHMENT_H


#include <iostream>
#include <iomanip>
#include <algorithm>
#include <functional>
#include <numeric>
#include <vector>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "mark_set.hpp"
#include "gene_set_motif_enrichment_base.hpp"


class BinomialGeneSetEnrichment : public GeneSetEnrichmentBase {
public:
    BinomialGeneSetEnrichment( unsigned int num_inside, unsigned int inside_size, unsigned int num_outside, unsigned int outside_size );
    BinomialGeneSetEnrichment() { }
    virtual ~BinomialGeneSetEnrichment() { }
    
    virtual void	print( ostream& os ) const;
    virtual void	printHeader( ostream& os ) const;
    
public: // (should be) constant public data members
    double			z;
};


class BinomialGeneSetEnrichmentCalculator : public GeneSetEnrichmentBaseCalculator {
public:
    BinomialGeneSetEnrichmentCalculator( const PromoterVector& promoters, const MarkSet& gene_set );
    BinomialGeneSetEnrichmentCalculator( const BinomialGeneSetEnrichmentCalculator& calc );
    virtual ~BinomialGeneSetEnrichmentCalculator() { }
    
    virtual void		compute( const MarkSet& marks, Statistic& statistic ); // fix this to take a GeneSetEnrichmentBase&
    
    // ack! terrible!
    virtual double		computeValue( const MarkSet& marks );
};

#endif // BINOMIAL_GENE_SET_MOTIF_ENRICHMENT_H
