/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  collect_incidence_matrix.cpp
 *
 *  Statistic calculator that collects the MarkSets given into a matrix.
 */


#include <iostream>
#include <iomanip>
#include <vector>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "mark_set.hpp"
#include "collect_incidence_matrix.hpp"


CollectIncidenceMatrix::CollectIncidenceMatrix( const PromoterVector& p, ostream& outStream, bool use_probes )
	: useProbes( use_probes ),
	  pv( p ),
	  os( outStream )
{
}


void
CollectIncidenceMatrix::compute( const MarkSet& marks, Statistic& statistic ) // 2nd parameter not used
{
	if( &statistic != 0 ) throw( MotifADEException( "CollectIncidenceMatrix::compute: 2nd argument required to be a null pointer!" ) );
	incidence.push_back( marks );
    return;
}


double
CollectIncidenceMatrix::computeValue( const MarkSet& marks )
{	
    throw( MotifADEException( "CollectIncidenceMatrix::computeValue is not supported because it doesn't make any sense." ) );
}


void
CollectIncidenceMatrix::printIncidenceMatrix() const
{
	unsigned int m = pv.size(), n = incidence.size();
	
	if( pv.size() == 0 )
		throw( MotifADEException( "CollectIncidenceMatrix::printIncidenceMatrix pv.size() == 0!" ) );
	
	bool use_expression = pv[ 0 ]->getExpression().size() > 0;
	
	os << "gene";
	if( useProbes )
		os << '\t' << "probe";
	if( use_expression )
		os << '\t' << "expression";
	
	for( unsigned int j = 0; j < n; ++j )
		os << '\t' << incidence[ j ].motif;
	os << endl;
	
	for( unsigned int i = 0; i < m; ++i ) {
		const Promoter& p = *pv[ i ];
		os << p.getID();
		if( useProbes )
			os << '\t' << p.getExpression().getID();
		if( use_expression )
			os << '\t' << p.getExpression( 0 ); // hard-coded expression dimension = 0. bad?
		
		for( unsigned int j = 0; j < n; ++j )
			os << '\t' << incidence[ j ][ i ];
		os << endl;
	}
}
