/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  common.cpp
 *
 *  Implementation of utility functions.
 */


#include "common.hpp"


using namespace std;


// procedure to convert a char to uppercase
char
char_toupper( char ch )
{
	if( ch >= 'a' && ch <= 'z' )
		return ch & ~32;
	return ch;
}


// procedure to convert a string to uppercase
string&
string_toupper( string& s )
{
    transform( s.begin(), s.end(), s.begin(), char_toupper );
//    for( string::iterator i = s.begin(); i != s.end(); ++i ) *i = *i & ~32;
    return s;
}


// procedure to parse a string into a double
double
string_atof( const string& s )
{
    return atof( s.c_str() );
}


// 02/07/04 -- all new tokenizers! snazzy! now in tokenizer.hpp


// fast way to tell if an unsigned int is odd
bool
isOdd( unsigned int x )
{
    return x & 1;
}


// fast inline-able absolute value function
double
fast_abs( double x )
{
    return ( x > 0 ? x : -x );
}


// fast inline-able square function
double
fast_square( double x )
{
    return x * x;
}


// fast way to double an integer
unsigned int
twice( unsigned int x )
{
	return x << 1;
}


// fast way to halve an integer
unsigned int
halve( unsigned int x )
{
	return x >> 1;
}


// fast way to multiply an integer by a power of four
unsigned int
times4n( unsigned int x, unsigned int n )
{
	return x << twice( n );
}


// splits a string into two parts separated by a delimiter, returns false if not found
string&
split( const string& text, string& first, string& second, const char delim )
{
	string::size_type pos = text.find( delim );
	
	if( pos == string::npos ) {
		first = text;
		second.resize( 0 );
		return first;
	} else {	
		first = text.substr( 0, pos );
		second = text.substr( pos + 1, string::npos );
		return first;
	}
}

unsigned long start_time, total_time = 0;
