/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  common.hpp
 *
 *  Interface to utility functions.
 */


#define MOTIFADE_CRAPPY_IOMANIP
//#define MOTIFADE_DEBUG
#define MOTIFADE_USE_FAST_IO
#define MOTIFADE_USE_HASH_MAP
//#define MOTIFADE_HASH_MAP_NOT_IN_EXT
#define MOTIFADE_DUMB_GNU_HASH_MAP
#define MOTIFADE_DUMB_STDINT
//#define MOTIFADE_DUMB_FLOATING_POINT
//#define NUCLEOTIDE_DISTRIBUTION_THROW_ON_BAD_NT


#ifndef COMMON_H
#define COMMON_H


#ifdef MOTIFADE_DUMB_STDINT
	typedef		unsigned char		uint8_t;
#else
   #include <stdint.h>
#endif



#include <string>
#include <vector>
#include <algorithm>
#include <iostream>
#include <exception>
#include <iterator>
#include <cctype>
#include <cstdlib>
#include <cmath>


using namespace std;


// vector typedefs -- hopefully will save some typing
typedef vector< string >		svector;
typedef vector< unsigned int >  uvector;
typedef vector< double >		dvector;


// simple functor for generating sorting permuatations
template< typename DataType >
struct SortingPermutationCmp {
	SortingPermutationCmp( DataType& x ) : theData( x ) {}
	
	bool operator()( unsigned int lhs, unsigned int rhs ) {
		return theData[ lhs ] < theData[ rhs ];
	}
	
	DataType& theData;
};


// procedure to convert a char to uppercase
char
char_toupper( char ch );


// procedure to convert a string to uppercase
string&
string_toupper( string& s );


// procedure to parse a string into a double
double
string_atof( const string& s );


// 02/07/04 -- all new tokenizers! snazzy! now in tokenizer.hpp


// fast way to tell if an unsigned int is odd
bool
isOdd( unsigned int x );


// fast inline-able absolute value function
double
fast_abs( double x );


// fast inline-able square function
double
fast_square( double x );


// fast inline-able max function
template< typename T >
T
fast_max( T a, T b )
{
	return a > b ? a : b;
}


// fast inline-able min function
template< typename T >
T
fast_min( T a, T b )
{
	return a < b ? a : b;
}


// fast way to double an integer
unsigned int
twice( unsigned int x );


// fast way to halve an integer
unsigned int
halve( unsigned int x );


// fast way to multiply an integer by a power of four
unsigned int
times4n( unsigned int x, unsigned int n );


// MotifADEException class -- (kludge) used for all exceptions
class MotifADEException : public std::exception {
public:
	MotifADEException( const char* msg )	throw() : exception(), message( msg ) { }
	virtual ~MotifADEException()			throw() { }
	virtual const char* what()				const throw() { return message.c_str(); }
private:
	string									message;
};


// splits a string into two parts separated by a delimiter, returns false if not found
string&
split( const string& text, string& first, string& second, const char delim = '\t' );


// template for swapping two objects
template< typename T >
inline void
fast_swap( T& a, T& b ) {
	static T tmp;
	tmp = a;
	a = b;
	b = tmp;
}


// simple templated functor for delete
template< typename T >
struct Delete {
	void operator()( T t )
	{ 
		delete t;
	}
};


// simple templated function for deleting all elements of a vector of pointers
template< typename T >
void
deleteVectorElements( vector< T >& v )
{
	for_each( v.begin(), v.end(), Delete< T >() );
}


// algorithm that takes a sequence [first, last) and returns a pair of iterators
// rslt such that for all x in [rslt.first, rslt.last): pred( *x ) is true.
template < typename InputIterator, typename Predicate >
pair< InputIterator, InputIterator >
range_find_if( InputIterator first, InputIterator last, Predicate pred )
{
  pair< InputIterator, InputIterator > rslt;
  rslt.first  = find_if( first, last, pred );
  rslt.second = find_if( rslt.first, last, not1( pred ) );
  return rslt;
}


// simple functor that returns true if its argument matches \w
struct IsAlphaNumeric {
  typedef char argument_type;
  bool operator()( argument_type c ) const {
    return isalnum( c ) || c == '_'; 
  }
};


extern unsigned long start_time, total_time;

#ifdef MOTIFADE_DEBUG
	
	#define HERE		cout << "got here!" << endl;
	
	#define WAYPOINT(x) cout << "WAYPOINT: " x << endl;

	#define CLOCK   cout << "clock: " << static_cast< double >( clock() ) / static_cast< double >( CLOCKS_PER_SEC ) << endl;
	
	#define TIMED(x) start_time = clock(); x; total_time += clock() - start_time;
	
	#define DEBUG_BLOCK(x) x
	
#else

	#define HERE
	
	#define WAYPOINT(x)
	
	#define CLOCK
	
	#define TIMED(x) x
	
	#define DEBUG_BLOCK(x)
	
#endif

#endif // COMMON_H

