/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  conserved_motif_scanner.hpp
 *
 *  Class for scanning conserved motifs with a given statistic calculator.
 */


#ifndef CONSERVED_MOTIF_SCANNER_H
#define CONSERVED_MOTIF_SCANNER_H


#include <string>
#include <vector>

#include "common.hpp"
#include "mark_set.hpp"
#include "motif_incidence_set.hpp"
#include "motif_incidence_computer.hpp"
#include "motif_incidence_marker.hpp"
#include "expression_statistics.hpp"
#include "statistic_receiver.hpp"
#include "motif_scanner.hpp"


class ConservedMotifScanner : public MotifScanner {
public:
	ConservedMotifScanner( const MotifIncidenceMap* incidence_map, const vector< const MotifIncidenceMap* >& ortholog_incidence_maps, MotifIncidenceComputer* incidence_computer, unsigned int numSeqs )
	: MotifScanner( incidence_map, incidence_computer, numSeqs ),
	  orthologIncidenceMaps( ortholog_incidence_maps ),
	  tempMarks( numSeqs ) {}
	
	virtual ~ConservedMotifScanner() {}
	
protected:	
	virtual void	markMotif( MotifIncidenceMap::MotifNumber motifNum, MarkSet& marksRef );
	
	void			intersectMarks( const MarkSet& aMarks, const MarkSet& bMarks, MarkSet& outMarks );
	
protected:
	const vector< const MotifIncidenceMap* >&	orthologIncidenceMaps;
	
	MarkSet										tempMarks;
};

#endif // CONSERVED_MOTIF_SCANNER_H
