/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  expression_set_reader.cpp
 *
 *  Class that reads an ExpressionSet from a stream.
 */

#include <set>
#include <iostream>
#include <string>
#include <cctype>


#include "common.hpp"

#include "buffered_reader.hpp"
#include "sequence.hpp"
#include "sequence_set.hpp"
#include "operation_stats.hpp"
#include "expression_set.hpp"
#include "expression_set_reader.hpp"


		
void
ExpressionSetReader::load( ExpressionSet& expr, Stats& stats ) {
	stats.clear();
	stats.removeRepeatedIDs = removeRepeatedIDs;
	
	if( !is ) throw( MotifADEException( "ExpressionSetReader::load: couldn't read from stream!" ) );
	
	is.getline( stats.header, '\n' );
			
	while( !is.eof() ) {
		char ch = is.peek();
		if( !isprint( ch ) ) {
			is.get();
			continue;
		}
	
		ExpressionVector* tmp = new ExpressionVector;
		is >> *tmp;
		
		if( useRankOrder ) {
			tmp->resize( 1 );
			tmp->front() = stats.num_vectors_loaded;
		}
		
		++stats.num_vectors_loaded;
		
		bool unique = expr.add( tmp );
		if( !unique ) {
			stats.repeatedIDs.insert( tmp->getID() );
			++stats.num_id_repeats;
			delete tmp;
		}
	}
	
	stats.num_repeated_ids = stats.repeatedIDs.size();
	stats.num_unique_ids = expr.size() - stats.num_repeated_ids;
	
	if( removeRepeatedIDs )
		for( IDSet::iterator i = stats.repeatedIDs.begin(); i != stats.repeatedIDs.end(); ++i )
			expr.remove( *i );
	
	stats.num_vectors_retained = expr.size();
}

