/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  expression_vector.hpp
 *
 *  Simple class for storing a vector of expression data.
 */


#ifndef EXPRESSION_VECTOR_H
#define EXPRESSION_VECTOR_H


#include <vector>
#include <iostream>
#include <algorithm>

#include "common.hpp"
#include "buffered_reader.hpp"
#include "tokenizer.hpp"
#include "id_object.hpp"


using namespace std;


class ExpressionVector : public IDObject< string >, public dvector {
};


// method to read an ExpressionVector from a BufferedReader (need to make BufferedReader an istream!)
BufferedReader& operator>>( BufferedReader& is, ExpressionVector& ev );


ostream& operator<<( ostream& os, const ExpressionVector& ev );


#endif // EXPRESSION_VECTOR_H

