/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_collection.cpp
 *
 *  Simple specialization of map to a hold instances of GeneIDSet.
 */


#include <iostream>
#include <map>

#include "common.hpp"
#include "gene_id_set.hpp"
#include "gene_id_set_collection.hpp"


ostream& operator<<( ostream& os, const GeneIDSetCollection& geneSets )
{
	for( GeneIDSetCollection::const_iterator i = geneSets.begin(); i != geneSets.end(); ++i ) {
		GeneIDSet::const_iterator j = i->second.begin();
		os << i->first << '\t' << *j++;
		for(; j != i->second.end(); ++j )
			os << ',' << *j;
		os << endl;
	}
	return os;
}

