/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  hypergeometric_gene_set_motif_enrichment.hpp
 *
 *  Class for comparing the incidence of motifs in a given gene set to
 *  background using a hypergeometric null model.
 */


#ifndef HYPERGEOMETRIC_GENE_SET_MOTIF_ENRICHMENT_H
#define HYPERGEOMETRIC_GENE_SET_MOTIF_ENRICHMENT_H


#include <iostream>
#include <iomanip>
#include <algorithm>
#include <functional>
#include <numeric>
#include <vector>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "mark_set.hpp"
#include "gene_set_motif_enrichment_base.hpp"


class HypergeometricGeneSetEnrichment : public GeneSetEnrichmentBase {
public:
    HypergeometricGeneSetEnrichment( double log_p_init, unsigned int num_inside, unsigned int inside_size, unsigned int num_outside, unsigned int outside_size );
    HypergeometricGeneSetEnrichment() { }
    virtual ~HypergeometricGeneSetEnrichment() { }
    
    virtual void	print( ostream& os ) const;
    virtual void	printHeader( ostream& os ) const;

public: // should be const...
	double			log_p;
};


class HypergeometricGeneSetEnrichmentCalculator : public GeneSetEnrichmentBaseCalculator {
public:
    HypergeometricGeneSetEnrichmentCalculator( const PromoterVector& promoters, const MarkSet& gene_set );
    HypergeometricGeneSetEnrichmentCalculator( const HypergeometricGeneSetEnrichmentCalculator& calc );
    virtual ~HypergeometricGeneSetEnrichmentCalculator() { }
    
    virtual void		compute( const MarkSet& marks, Statistic& statistic ); // fix this to take a GeneSetEnrichmentBase&
    
    // ack! terrible!
    virtual double		computeValue( const MarkSet& marks );

protected:
	void				initNFactorial();
		
	double				logFactorial( unsigned int n ) const;
	double				logNChooseK( unsigned int n, unsigned int k ) const;
	double				logHypergeometricPDF( unsigned int numDrawn, unsigned int sampleSize, unsigned int numPop, unsigned int popSize ) const;
	double				logHypergeometricCDF( unsigned int numDrawn, unsigned int sampleSize, unsigned int numPop, unsigned int popSize, bool lower_tail = true );
	
protected:
	dvector				logNFactorial;
	dvector				cdfTemp;
};

#endif // HYPERGEOMETRIC_GENE_SET_MOTIF_ENRICHMENT_H
