/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  sequence_set.hpp
 *
 *  Simple class for objects to be contained in an IDObjectSet.
 */


#ifndef ID_OBJECT_H
#define ID_OBJECT_H


#include "common.hpp"


template< typename _IDType >
class IDObject {
public:
	typedef _IDType				IDType;
	
public:
	~IDObject() {}
	const IDType&		getID()							const { return id; }
    void				setID( const IDType& newID )	{ id = newID; }
	
protected:
    IDType				id;
};


#endif // ID_OBJECT_H
