/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  iupac_motif.hpp
 *
 *  Class for storing IUPAC-degenerate motifs.
 */


#ifndef IUPAC_MOTIF_H
#define IUPAC_MOTIF_H


#include <string>
#include <vector>
#include <algorithm>
#include <functional>
#include <numeric>
#include <iostream>
#include <iterator>


#include "common.hpp"
#include "tokenizer.hpp"



const unsigned int ASIZE = 128;


class IUPACMotif {
public:
    IUPACMotif( const string& init_name, const string& init_pattern );
    IUPACMotif( const string& raw_motif );
	    
	static bool isValidPattern( const string& motif_pattern, string::size_type pos = 0 );
	static bool isValidRaw( const string& raw_pattern );
	
    // constructor parsing helpers
    void parseMotifPattern( const string& motif_pattern );
	
    // accessors
    const string&					getName()						const { return name; }
    const string&					getPattern( unsigned int i )	const { return patterns[ i ]; }
    unsigned int					numPatterns()					const { return patterns.size(); }
    const svector&					getPatterns()					const { return patterns; }
	void							getPatterns( string& dst )		const;
	void							getReverseComplementPatterns( string& dst ) const;
    
private:
	char							getComplement( char ch ) const;
	void							getComplement( const string& motif, string& dst ) const;
	void							getReverse( const string& motif, string& dst ) const;
	void							getReverseComplement( const string& motif, string& dst ) const;
	
	
private:
    string							name;
    svector							patterns;
};


typedef vector< IUPACMotif* >	IUPACMotifVector;



ostream& operator<<( ostream& os, const IUPACMotif& m );


#endif // IUPAC_MOTIF_H
