/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  iupac_motif_incidence_collector.hpp
 *
 *  Class for collecting the incidence of a set of IUPAC-degenerate motifs
 *  in a set of sequences into a MotifIncidenceMap.
 */


#ifndef IUPAC_MOTIF_INCIDENCE_COLLECTOR_H
#define IUPAC_MOTIF_INCIDENCE_COLLECTOR_H


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "iupac_motif.hpp"
#include "motif_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"
#include "named_motif_incidence_collector.hpp"


class IUPACMotifIncidenceCollector : public NamedMotifIncidenceCollector {
public:
	
	IUPACMotifIncidenceCollector( IUPACMotifVector& motif_v ) : motifVector( motif_v ) {}
	virtual ~IUPACMotifIncidenceCollector() {}
	
	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs );
	
protected:

	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs, IUPACMotifVector& motifs ) = 0;
	
	void setMotifNames( IUPACMotifVector& motifs, IUPACMotifIncidenceMap* m );
	
protected:
	
	IUPACMotifVector& motifVector;
};


#endif // IUPAC_MOTIF_INCIDENCE_COLLECTOR_H
